//______________________________________________________________________________

//	The Java Virtual Shelf
//______________________________________________________________________________

package org.demo.webwader.rbi;

import java.io.PrintStream;
/**
 * An object used to see whether a Displayer is available or not.
 * <Br>
 * This program does not depend on any other JVS object.
 *
 * @version $Id: DisplayersProbe.java,v 1.7 2001/05/28 15:03:34 lefevre Exp $
 * @author Jean-Paul Le Fvre
 * @see DisplayersBag
 */
//______________________________________________________________________________

public class DisplayersProbe {
    /**
     * A flag to change the volume of information printed.
     */
static protected boolean debug = false;
    /**
     * The string printed if the displayer is found.
     */
static private final String YES = "yes";
    /**
     * The string printed if the displayer is not found.
     */
static private final String NO = "no";

//______________________________________________________________________________
 /**
  * Checks if a displayer can be loaded.
  * <br>
  * For each known displayer a class name is tested.
  * This method does not throw any exception but return false
  * in case of error.
  * @param displayer the name of a possible displayer
  * @see Class#forName
  */
static protected boolean isAvailable(String displayer)
  {
      if(displayer == null) return false;

      String classname = null;

      if(displayer.equals("RemoteSwing")) {
	  classname = "javax.swing.JEditorPane";
      }
      else if(displayer.equals("IceDisplayer")) {
	  classname = "ice.storm.StormBase";
      }
      else if(displayer.equals("HorstDisplayer")) {
	  classname = "horst.HTMLPane";
      }
      else if(displayer.equals("ClueDisplayer")) {
	  classname = "com.netclue.browser.AsynHtmlPane";
      }
      else if(displayer.equals("XBrowser")) {
	  classname = "xbrowser.XBrowser";
      }
      else {
	  return false;
      }

      try {
	  /**
	   * This stupid IceBrowser outputs uninteresting messages
	   * screwing up my configuration scripts. To work around
	   * messages are redirected to stderr which in turn can
	   * be sent to /dev/null.
	   */
	  PrintStream out = System.out;
	  System.setOut(System.err);
	  Class.forName(classname);
	  System.setOut(out);
      }
      catch(SecurityException ex) {
	  System.out.println("Can't probe " + displayer + ' ' +ex.getMessage());
	  return false;
      }
      catch(Exception ex) {
	  return false;
      }

      return true;
  }
//______________________________________________________________________________
    /**
     * The main program.
     * <br>
     * Usage : org.demo.webwader.rbi.DisplayersProbe [-d] displayer_name
     * @param args the command line.
     */
public static void main (String[] args)
  {
      int i = 0;
      if(i < args.length && args[i].equals("-d")) {
	  debug = true;
	  i++;
      }

      if(i >= args.length) {
	  if(debug) {
	      System.err.println("Usage   : " +
	      "java org.demo.webwader.rbi.DisplayersProbe [-d] displayer_name");
	      System.err.println(
"Choices : RemoteSwing, IceDisplayer, HorstDisplayer, ClueDisplayer, XBrowser");
	  }
	  System.out.println(NO);
	  System.exit(1);
      }

      if(debug) {
	  System.out.println("Probing " + args[i] + " in " +
			     System.getProperty("java.class.path"));
      }

      System.out.println(isAvailable(args[i]) ? YES : NO);
      System.exit(0);
  }
//______________________________________________________________________________
}



