//______________________________________________________________________________

//	Java Virtual Shelf	- Jean-Paul Le Fevre
//______________________________________________________________________________

package org.demo.webwader.rbi;

import org.ariane.tools.ToolBox;
import java.rmi.server.*;
import java.rmi.RemoteException;
import java.net.URL;
import java.util.Date;

/**
 * This server knows how to display a document.
 *
 * @author   Jean-Paul Le Fvre
 * @version $Id: DisplayerServant.java,v 1.3 2001/01/28 11:34:46 lefevre Exp $
 */

class DisplayerServant extends UnicastRemoteObject
                       implements RemoteDisplayer, Unreferenced {
  /**
   * @serial The bag of tools used to display pages.
   */
private DisplayersBag bag = null;

//______________________________________________________________________________
/**
 * Creates the servant.
 * @param port the port number on which the remote object receives calls.
 * @throw RemoteException if the base object cannot be created.
 */
protected DisplayerServant(int port) throws RemoteException
  {
      super(port);

      bag = DisplayersBag.instance();
  }
//______________________________________________________________________________
/*
 * Sets a new current displayer.
 * @param name the new displayer.
 * @return true is the displayer is actually changed, false otherwise.
 * @throw RemoteException if the call cannot be completed.
 */
final public boolean changeDisplayer(String name) throws RemoteException
{
    if(ToolBox.debug) {
	try {
	    ToolBox.warn("Displayer " + name +
			 " requested by " + getClientHost());
	}
	catch(ServerNotActiveException ex) {
	    ToolBox.warn("Can't get name of the client", ex);
	}
    }
    return BrowserPane.instance().changeDisplayer(name);
}
//______________________________________________________________________________
/*
 * Activates this tool.
 * @throw RemoteException if the call cannot be completed.
 */
final public void activate() throws RemoteException
{
    bag.getDisplayer().activate();
}
//______________________________________________________________________________
/*
 * Displays a HTML page.
 * <br>
 * It the url points to a document which is not displayable, the method
 * returns false.
 *
 * @param url the URL of the document to show.
 * @return true if the page has been actually shown, false otherwise.
 * @throw RemoteException if the call cannot be completed.
 */
final public boolean displayPage(URL url) throws RemoteException
{
    return bag.getDisplayer().displayPage(url);
}
//______________________________________________________________________________
/*
 * Gets the name of the current displayer.
 * @return a ident.
 * @throw RemoteException if the call cannot be completed.
 */
final public String getName() throws RemoteException
{
    return bag.getDisplayer().getName();
}
//______________________________________________________________________________
/*
 * Prints a message when there is no more clients.
 */
final public void unreferenced()
{
    ToolBox.warn("No more clients connected at " + (new Date()).toString());
}
//______________________________________________________________________________
}
