//______________________________________________________________________________

//	Java Virtual Shelf	- Jean-Paul Le Fevre
//______________________________________________________________________________

package org.demo.webwader.rbi;
import java.net.URL;

/**
 * A displayer knows how to display a document.
 * @author   Jean-Paul Le Fvre
 * @version $Id: Displayer.java,v 1.2 2001/01/03 20:56:17 lefevre Exp $
 */

interface Displayer {
  /*
   * Activates this tool.
   */
void activate();
  /*
   * Displays a HTML page.
   * <br>
   * It the url points to a document which is not displayable, the method
   * returns false.
   *
   * @param url the locator of the document to show.
   * @return true if the page has been actually shown, false otherwise.
   */
boolean displayPage(String url);
  /*
   * Gets the name of the displayer.
   * @return a ident.
   */
String getName();

//______________________________________________________________________________
}









