//______________________________________________________________________________

//	The Java Virtual Shelf
//______________________________________________________________________________

package org.demo.webwader.rbi;

import javax.swing.*;
import java.awt.Component;
import java.awt.Dimension;
import org.ariane.tools.ToolBox;

/**
 * A customized Dialog : used to get a possible confirmation from the user.
 *
 * @version $Id: Confirmer.java,v 1.2 2001/01/03 20:56:16 lefevre Exp $
 * @author Jean-Paul Le Fvre
 */
//______________________________________________________________________________

public class Confirmer extends Dialog {

  /**
   * @serial The unique instance.
   */
private  static Confirmer confirmer = null;

//______________________________________________________________________________
/**
 * Gets an unique instance of the confirmer.
 * <Br>
 * It is a singleton.
 * @return the unique instance.
 */
public static Confirmer instance()
  {
    if(confirmer == null) confirmer = new Confirmer();

    return confirmer;
  }
//______________________________________________________________________________
/**
 * Creates the Confirmer.
 */
private Confirmer()
  {
      super("Confirmation needed !  ", "confirm.gif");
  }
//______________________________________________________________________________
/**
 * Builds the main component.
 */
protected JComponent createComponent()
{
      JLabel label = new JLabel("Make your choice !");

      label.setHorizontalAlignment(JLabel.RIGHT);
      int margin = resources.getSpace();
      label.setBorder(BorderFactory.createEmptyBorder(0, margin, 0, margin));
      label.setForeground(resources.getMainForeground());

      setInitialSize("Confirmer", 350, 150);

      return label;
}
//______________________________________________________________________________
/**
 * Displays the confirmer and waits for a button pressed.
 * <Br>
 * @param question the test of the question to ask.
 * @return true if the answer is OK, false otherwise.
 * @see #actionPerformed
 */
public boolean ask(String question)
{
    ((JLabel)component).setText(question);

    return display();
}
//______________________________________________________________________________
}
