//______________________________________________________________________________

//	The Java Virtual Shelf
//______________________________________________________________________________

package org.demo.webwader.rbi;

import javax.swing.*;
import java.net.URL;
import org.ariane.tools.ToolBox;
import org.demo.webwader.gui.GuiResources;
import org.demo.webwader.gui.Displayer;
import com.netclue.browser.*;
import com.netclue.html.event.*;

/**
 * A displayer based on the NetClue package.
 * <br>
 * The NetClue API documentation is available 
 * <a href="http://www.netcluesoft.com/api/clue25/index.html">on line</a>
 * @version $Id: ClueDisplayer.java,v 1.5 2001/01/14 17:51:39 lefevre Exp $
 * @author Jean-Paul Le Fvre
 * @see SwingDisplayer
 */
//______________________________________________________________________________

public class ClueDisplayer extends AsynHtmlPane implements Displayer {
  /**
   * @serial The unique instance.
   */
private  static ClueDisplayer displayer = null;
    /**
     * @serial The name of this tool.
     */
public static final String NAME = DisplayersBag.CLUE_DISPLAYER_NAME;
    /**
     * @serial The set of properties.
     */
private GuiResources resources;

//______________________________________________________________________________
/**
 * Gets an unique instance of the displayer.
 * <Br>
 * It is a singleton
 * @return the unique instance.
 */
public static ClueDisplayer instance()
  {
    if(displayer == null) displayer = new ClueDisplayer();

    return displayer;
  }
//______________________________________________________________________________
/**
 * Creates the ClueDisplayer.
 * <Br>
 * It creates the AsynHtmlPane.
 * A hyperlink listener is added to update the URL text field.
 */
private ClueDisplayer()
  {
      super();

      resources  = GuiResources.instance();
      setOpaque(true);
      setBackground(resources.getPaneBackground());
      setForeground(resources.getPaneForeground());
      setFont(resources.getTextFont());

      class ClickListener implements HyperlinkListener {
	  public void hyperlinkTriggered(HyperlinkEvent ev) {
	      NavePane.instance().setURLField(ev.getURL());
	  }
      }
      addHyperlinkListener(new ClickListener());
  }
//______________________________________________________________________________
/**
 * Activates this displayer.
 * <br>
 * Simply displays the welcome page.
 */
final public void activate()
{
    try {
      displayPage(new URL(resources.getWelcomeLocation()));
    }
    catch(Exception ex) {
	ToolBox.warn("Can't display welcome page", ex);
	return;
    }
}
//______________________________________________________________________________
/**
 * Displays the specified document.
 * @param url the url of the page.
 * @return true is the page has been displayed.
 */
final public boolean displayPage(URL url)
{
    if(url == null) return false;

    try {
	NavePane.instance().setURLField(url);
	setPage(url);
	return true;
    }
    catch(Exception ex) {
	ToolBox.warn("Can't display page " + url.toString(), ex);
	return false;
    }
}
//______________________________________________________________________________
/**
 * Returns the name of this tool.
 * @return the string.
 */
final public String getName()
{
    return NAME;
}
//______________________________________________________________________________
}


