//______________________________________________________________________________

//	The Java Virtual Shelf
//______________________________________________________________________________

package org.demo.webwader.rbi;

import javax.swing.*;
import javax.swing.border.Border;
import java.awt.Component;
import java.awt.Dimension;
import java.net.*;
import java.io.InputStream;
import java.io.IOException;
import java.io.InputStream;
import org.ariane.tools.ToolBox;
import org.ariane.tools.Resources;
import org.demo.webwader.gui.GuiResources;
import org.demo.webwader.gui.Displayer;

/**
 * A customized Pane used to show the content of a web page.
 * <Br>
 * The component used to display the pages can be changed.
 * @version $Id: BrowserPane.java,v 1.7 2001/01/20 09:32:42 lefevre Exp $
 * @author Jean-Paul Le Fvre
 * @see SwingDisplayer
 */
//______________________________________________________________________________

class BrowserPane extends JScrollPane {
  /**
   * @serial The unique instance.
   */
private  static BrowserPane pane = null;
    /**
     * @serial The set of properties.
     */
private GuiResources resources;
  /**
   * @serial The bag of tools used to display pages.
   * It gives access to a current displayer.
   */
private DisplayersBag bag = null;

//______________________________________________________________________________
/**
 * Gets an unique instance of the pane.
 * <Br>
 * It is a singleton.
 * @return the unique instance.
 */
protected static BrowserPane instance()
  {
    if(pane == null) pane = new BrowserPane();

    return pane;
  }
//______________________________________________________________________________
/**
 * Creates the BrowserPane.
 */
private BrowserPane()
  {
      super();

      resources     = GuiResources.instance();
      Border border = BorderFactory.createCompoundBorder(
      resources.getMatteBorder(), resources.getLineBorder());
      setBorder(border);

      bag = DisplayersBag.instance();
      int index = bag.getDisplayerIndex(
	        resources.get(Browser.APPLI + ".Displayer", "SwingDisplayer"));

      bag.setDisplayer(index);
      Displayer displayer = bag.getDisplayer();
      setViewportView((Component)displayer);
      displayer.displayPage(getPage());
  }
//______________________________________________________________________________
/**
 * Changes the displayer.
 * <br>
 * It is made current and its component is installed.
 * @param index the index of the new displayer.
 * @return true if the displayer is actually changed.
 * @see #changeDisplayer
 */
final protected boolean setDisplayer(int index)
{
    int previous = bag.getDisplayerIndex();
    /**
     * No change, simply return
     */
    if(previous == index) return false;

    boolean done = bag.setDisplayer(index);
    if(! done) {
	MainFrame.inform("Displayer not changed !");
	return false;
    }

    Displayer displayer = bag.getDisplayer();

    if(displayer == null) {
	bag.setDisplayer(previous);
	return false;
    }

    MainFrame.inform("New displayer : " + displayer.getName());
    setViewportView((Component)displayer);

    URL url = null;
    try {
	url = NavePane.instance().getURL();
	if(url == null) url = getPage();
	displayer.displayPage(url);
    }
    catch(Exception ex) {
	ToolBox.warn("Can't get page " + String.valueOf(url), ex);
    }

    return true;
}
//______________________________________________________________________________
/**
 * Changes the current tool used to display pages.
 * <Br>
 * This method verifies that the displayer is available.
 * @param tool the name of the new displayer.
 * @return true is the displayer is actually changed.
 * @see #setDisplayer
 */
final public boolean changeDisplayer(String tool)
{
    if(! DisplayersProbe.isAvailable(tool)) {
	if(ToolBox.verbose)
	    ToolBox.warn("Displayer " + tool + " not available");
	return false;
	
    }

    if(ToolBox.debug) ToolBox.warn("Displayer : " + tool);
    
    return setDisplayer(bag.getDisplayerIndex(tool));
}
//______________________________________________________________________________
/**
 * Displays the specified document.
 * @param url the url of the page.
 * @return true is the page has been displayed.
 */
final protected boolean displayPage(URL url)
{
    return bag.getDisplayer().displayPage(url);
}
//______________________________________________________________________________
/**
 * Gets the name of the displayer.
 * @return the name of the current displayer.
 */
final protected String getDisplayerName()
{
    return bag.getDisplayer().getName();
}
//______________________________________________________________________________
/**
 * Gets the undefined page.
 * <br>
 * It is in file:/path/to/jvs/lib/webpage.html
 * @return the page.
 */
final private URL getPage()
{
    StringBuffer buf = new StringBuffer("file:");
    buf.append(Resources.instance().getLibDirectory());
    buf.append("webpage.html");

    try {
	return new URL(buf.toString());
    }
    catch(MalformedURLException ex) {
	return null;
    }
}
//______________________________________________________________________________
}



