//______________________________________________________________________________

//	The Java Virtual Shelf
//______________________________________________________________________________

package org.demo.webwader.gui;

import javax.swing.*;
import java.awt.Component;
import java.awt.Dimension;
import java.net.*;
import java.io.InputStream;
import java.io.IOException;
import java.io.InputStream;
import org.ariane.tools.ToolBox;
import org.ariane.tools.Resources;

/**
 * A customized Dialog used to show the content of a web page.
 * <Br>
 * @version $Id: WebWindow.java,v 3.3 2000/10/25 16:15:05 lefevre Exp $
 * @author Jean-Paul Le Fvre
 * @see SwingDisplayer
 */
//______________________________________________________________________________

class WebWindow extends Dialog {
  /**
   * @serial The unique instance.
   */
private  static WebWindow window = null;
  /**
   * @serial The text pane.
   */
private JEditorPane editor;

//______________________________________________________________________________
/**
 * Gets an unique instance of the window.
 * <Br>
 * It is a singleton
 * @return the unique instance.
 */
protected static WebWindow instance()
  {
    if(window == null) window = new WebWindow();

    return window;
  }
//______________________________________________________________________________
/**
 * Creates the WebWindow.
 * <Br>
 * It is a non modal dialog window.
 */
private WebWindow()
  {
      super("Web Pager  ", "jvs.gif", false);
      ok_button.setVisible(false);
      cancel_button.setToolTipText("To close the window");
  }
//______________________________________________________________________________
/**
 * Builds the main component.
 * @return the component.
 */
protected JComponent createComponent()
{
    editor    = new JEditorPane();

    editor.setEditable(false);
    editor.setOpaque(true);
    editor.setBackground(resources.getPaneBackground());
    editor.setForeground(resources.getPaneForeground());
    editor.setFont(resources.getTextFont());

    URL url = null;
    try {
	url = getPage();
	editor.setPage(url);
    }
    catch(Exception ex) {
	writeText(getText());
	ToolBox.warn("Can't get page " + String.valueOf(url), ex);
    }

    setInitialSize("WebWindow", 600, 700);

    JScrollPane scroll = new JScrollPane(editor);
    Dimension dim      = getInitialSize();

    int w = dim.width;
    int h = dim.height - 200;
    if(h < 100) h = 100;
    dim.setSize(w, h);
    scroll.setPreferredSize(dim);
    scroll.setBorder(resources.getMatteBorder());

    return scroll; 
}
//______________________________________________________________________________
/**
 * Displays the specified stream.
 * @param in The stream to read from.
 * @param url the url of the page.
 * @return true is the page has been displayed.
 * @see JEditorPane#read
 * @throw IOException if the stream cannot be read
 */
final protected void display(InputStream in, URL url) throws IOException
{
    setVisible(true);
    editor.read(in, url);
}
//______________________________________________________________________________
/**
 * Displays a text.
 * @param text the string to write.
 */
final protected void writeText(String text)
{
    editor.setText(text);
}
//______________________________________________________________________________
/**
 * Creates a text to be displayed.
 * @return the string.
 */
private String getText()
{
    return "To see a Web Page use your favorite browser !";
}
//______________________________________________________________________________
/**
 * Gets the undefined page.
 * <Br>
 * It is in file:/path/to/jvs/lib/webpage.html
 *
 * @return the page.
 * @throw java.net.MalformedURLException is the url is wrong.
 */
final private URL getPage() throws java.net.MalformedURLException
{
    StringBuffer buf = new StringBuffer("file:");
    buf.append(Resources.instance().getLibDirectory());
    buf.append("webpage.html");

    String path = buf.toString();

    return new URL(path);
}
//______________________________________________________________________________
}


