//______________________________________________________________________________

//	The Java Virtual Shelf
//______________________________________________________________________________

package org.demo.webwader.gui;

import org.demo.webwader.VersionInfo;
import javax.swing.*;
import org.ariane.tools.ToolBox;

/**
 * A customized Dialog used to display information about the program.
 *
 * @version $Id: VersionWindow.java,v 3.2 2001/01/07 13:18:39 lefevre Exp $
 * @author Jean-Paul Le Fvre
 * @see VersionInfo
 */
//______________________________________________________________________________

class VersionWindow extends Dialog {

  /**
   * @serial The unique instance.
   */
private  static VersionWindow window = null;

//______________________________________________________________________________
/**
 * Gets an unique instance of the window.
 * <Br>
 * It is a singleton
 * @return the unique instance.
 */
protected static VersionWindow instance()
  {
    if(window == null) window = new VersionWindow();

    return window;
  }
//______________________________________________________________________________
/**
 * Creates the VersionWindow.
 */
private VersionWindow()
  {
      super("About WebWader  ", "help.gif");
      ok_button.setVisible(false);
      cancel_button.setToolTipText("To close the window");
  }
//______________________________________________________________________________
/**
 * Builds the main component.
 * @return the component.
 */
protected JComponent createComponent()
{
    JTextArea text = new JTextArea();

    text.setEditable(false);
    text.setOpaque(true);
    text.setBackground(resources.getPaneBackground());
    text.setForeground(resources.getPaneForeground());
    text.setFont(resources.getTextFont());
    text.setBorder(makeMarginBorder());

    setInitialSize("Version", 350, 200);

    text.setText(writeText());

    return text;
}
//______________________________________________________________________________
/**
 * Creates the text to be displayed.
 * @return the string.
 */
private String writeText()
{
    StringBuffer buf = new StringBuffer("Current version : ");

    buf.append(VersionInfo.VERSION).append('\n');
    buf.append("Available since : ").append(VersionInfo.DATE).append('\n');
    buf.append("Author's e-mail : ").append(VersionInfo.AUTHOR).append('\n');

    return buf.toString();
}
//______________________________________________________________________________
}


