//______________________________________________________________________________

//	The Java Virtual Shelf
//______________________________________________________________________________

package org.demo.webwader.gui;

import org.demo.webwader.*;
import org.ariane.tools.ToolBox;

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.event.*;
import javax.swing.tree.*;

/**
 * The customized TreePane.
 * <Br>
 * It adds methods to manage a web site tree.
 * @version $Id: TreePane.java,v 3.4 2000/10/25 16:15:05 lefevre Exp $
 * @author Jean-Paul Le Fvre
 * @see DefaultMutableTreeNode
 */
//______________________________________________________________________________

public	class TreePane extends JTree {
  /**
   * @serial The unique instance.
   */
private static TreePane  tree_pane = null;
    /**
     * @serial The root node of the tree.
     */
private DefaultMutableTreeNode root;

//______________________________________________________________________________
/**
 * Gets an unique instance of the TreePane.
 * <Br>
 * It is a singleton.
 * @return the unique instance.
 */
protected static TreePane instance()
  {
    if(tree_pane == null) tree_pane = new TreePane();

    return tree_pane;
  }
//______________________________________________________________________________
/**
 * Creates the TreePane.
 */
private TreePane()
  {
      super();
      GuiResources resources = GuiResources.instance();
      Color fg               = resources.getBoardForeground();

      setBackground(resources.getBoardBackground());
      setForeground(fg);
      setEditable(false);
      setBorder(resources.getMarginBorder());
      getSelectionModel().setSelectionMode
	  (TreeSelectionModel.SINGLE_TREE_SELECTION);
      /**
       * Defines the renderer used to display nodes.
       */
      class CellRenderer extends DefaultTreeCellRenderer {
      }

      CellRenderer renderer = new CellRenderer();
      renderer.setFont(resources.getTextFont());
      renderer.setForeground(fg);
      renderer.setBackgroundNonSelectionColor(resources.getBoardBackground());
      renderer.setBackgroundSelectionColor(resources.getSelectionColor());
      renderer.setLeafIcon(resources.getIcon("text.gif"));
      renderer.setOpenIcon(renderer.getLeafIcon());
      renderer.setClosedIcon(resources.getIcon("hypertext.gif"));
      setCellRenderer(renderer);

      try {
	  root    = new WebRoot();
      }
      catch(InvalidLocatorException ex) {
      }

      DefaultTreeModel model = new DefaultTreeModel(root);
      setModel(model);

      /**
       * Defines what to do when a new node is selected.
       * It can be the result of a action performed with the
       * navigation buttons or of a mouse click.
       */
      class NodeListener implements TreeSelectionListener {
	  public void valueChanged(TreeSelectionEvent ev) {
	      processNodeSelection(
	      (DefaultMutableTreeNode)ev.getPath().getLastPathComponent());
	  }
      }

      addTreeSelectionListener(new NodeListener());

      /**
       * Defines what to do when a mouse click happens.
       */
      MouseListener ml = new MouseAdapter() {
	 final public void mouseClicked(MouseEvent ev) {
	    processNodeMouseSelection(ev);
	 }
       };

      addMouseListener(ml);
  }
//______________________________________________________________________________
  /**
   * Displays the content of the web site.
   * @param site the new site to display.
   */
final protected void displaySiteMap(WebSite site)
{
    root.removeAllChildren();

    if(site != null) {
	root.add(site.getTopNode());
    }

    ((DefaultTreeModel)getModel()).reload();
}
//______________________________________________________________________________
  /**
   * Resets the default cursor.
   * @see Cursor#getDefaultCursor()
   */
final protected void setDefaultCursor()
{
    setCursor(Cursor.getDefaultCursor());
}
//______________________________________________________________________________
  /**
   * Changes the cursor to the busy bitmap.
   * @see Cursor#getPredefinedCursor()
   */
final private void setBusyCursor()
{
    setCursor(Cursor.getPredefinedCursor(Cursor.WAIT_CURSOR));
}
//______________________________________________________________________________
/**
 * Handles a new node selection.
 *
 * @param node the node selected. Can be null : means root node.
 * @see NavePane#updateNodeInfo
 */
final private void processNodeSelection(DefaultMutableTreeNode node)
{
    NavePane.instance().updateNodeInfo((WebNode)node);
}
//______________________________________________________________________________
/**
 * Handles a new node selection with the mouse.
 * <Br>
 * It displays the node and positions the iterator.
 * @param ev the mouse event to process.
 * @see NavePane#displaySelectedNode
 */
final private void processNodeMouseSelection(MouseEvent ev)
{
    TreePath path = getPathForLocation(ev.getX(), ev.getY());
    if(path == null) return;

    WebNode node = (WebNode)path.getLastPathComponent();

    NavePane.instance().displaySelectedNode(node);
}
//______________________________________________________________________________
/**
 * Changes the selected node.
 *
 * @param node the node to select.
 */
protected void setSelectedNode(DefaultMutableTreeNode node)
{
    if(node == null) {
	node = root;
    }
    TreeModel model = getModel();
    TreeNode[] tn   = ((DefaultTreeModel)model).getPathToRoot(node);
    TreePath path   = new TreePath(tn);

    setSelectionPath(path);
}
//______________________________________________________________________________
}



