//______________________________________________________________________________

//	Java Virtual Shelf
//______________________________________________________________________________

package org.demo.webwader.gui;

import org.demo.webwader.VersionInfo;
import org.ariane.tools.TryProg;
import org.ariane.tools.ToolBox;
import org.ariane.tools.ResourcesException;
import java.util.Locale;
import java.io.IOException;
import java.io.File;

/**
 * The main program.
 * <P>
 * <Code>
 * Usage : java org.demo.webwader.gui.Traverser
 *         [-v|d|q][-V][-h][-W][-S][-s sitefile]
 * </Code>
 * <P>
 * It parses the command line.
 * It launches the Graphical User Interface for the WebWader application.
 *
 * @see MainFrame
 * @version $Id: Traverser.java,v 3.7 2001/01/13 18:28:19 lefevre Exp $
 * @author  Jean-Paul Le Fvre
 */

public class Traverser extends TryProg {
    /**
     * @serial The name of the application. Used to fetch properties.
     */
public static final String APPLI = "WebWader";
    /**
     * @serial the main window.
     */
private MainFrame frame;
    /**
     * @serial the name of a file storing a site description.
     */
private String sitefile = null;
    /**
     * @serial the flag indicating if the scan window must be open.
     */
private boolean scanopen = false;

//______________________________________________________________________________
    /**
     * The main program.
     * @param args the command line.
     */
public static void main (String[] args)
  {
      ToolBox.debug   = false;
      ToolBox.verbose = true;
      Traverser prog  = new Traverser();

      if (! prog.parseArg(args)) {
	  System.err.println("Can't parse command line !");
	  exitWrong();
      }

      if (! prog.run()) {
	  System.err.println("Can't execute Traverser !");
	  exitWrong();
      }
  }
//______________________________________________________________________________
  /**
   * Creates the program.
   * <Br>
   * It loads the properties used in the application : the default JVS
   * values, the general WebWader values and the user values.
   */
public Traverser()
  {
      super("Traverser");
      setResources();
  }
//______________________________________________________________________________
/**
 * Launches the program : builds the main frame.
 * @return true if successful.
 * @see MainFrame
 */
public	boolean run()
  {
      if(ToolBox.verbose) {
	  String locale = Locale.getDefault().getDisplayName();
	  System.out.println("Creating Traverser GUI " + locale + " !");
      }
      if(ToolBox.debug) {
	  System.out.println(VersionInfo.instance().toString());
	  System.out.println("XML is available : " + ToolBox.hasXML());
      }

      ToolBox.dot();

    try {
	frame = MainFrame.instance();

	DisplayersBag.instance().setDisplayer(
			resources.get(APPLI + ".Displayer", "WebWindow"));

	if(scanopen) ScanWindow.instance().display();
    }
    catch(ResourcesException ex) {
	ToolBox.warn("Can't manage resources " + ex);
	ToolBox.warn(
        "Try -Djvs.home=path_to_JVS or -cp path_to_JVS/lib/jvs.jar");
	return false;
    }
    catch(Exception ex) {
	ToolBox.warn("Can't run Traverser " + ex);
	return false;
    }

    if(sitefile != null) {
	try {
	    File file = new File(sitefile);
	    Controller.instance().openFile(file);
	}
	catch(IOException ex) {
	    ToolBox.warn("Can't open " + sitefile, ex);
	}
    }

    return true;
  }
//______________________________________________________________________________
/**
 * Installs the specific resources.
 * @see	org.demo.webwader.Resources
 */
protected void setResources()
  {
      resources = org.demo.webwader.Resources.instance();
  }
//______________________________________________________________________________
    /**
     * Prints how to use the program.
     */
private	void printUsage()
  {
      System.out.println(
      "Usage   : java org.demo.webwader.gui.Traverser [options]");
      System.out.println(
      "Options : [-v|-d|-q][-V][-h][-S][-s sitefile]");
  }
//______________________________________________________________________________
    /**
     * Parses the command line.
     * <Br>
     * <Code>Usage   : -v|d|q -V -h -S -s sitefile</Code>
     * @return true if the command line is correct.
     */
public	boolean parseArg(String args[])
  {
    int i          = 0;
    int error      = 0;

    while(i < args.length && args[i].startsWith("-")) {

      String arg = args[i++];
      int j;

      for (j = 1; j < arg.length(); j++) {

	char flag = arg.charAt(j);

	switch (flag) {
	case 'V':
	  org.demo.webwader.VersionInfo.print();
	  break;

	case 'v':
	  ToolBox.verbose = true;
	  ToolBox.debug   = false;
	  break;

	case 'd':
	  ToolBox.verbose = true;
	  ToolBox.debug   = true;
	  break;

	case 'q':
	  ToolBox.verbose = false;
	  ToolBox.debug   = false;
	  break;

	case 'S':
	  scanopen = true;
	  break;

	case 's':
	  sitefile = args[i++];;
	  break;

	default	:
	  printUsage();
	  error++;
	  break;
	}
      }
    }

    return (error == 0);
  }
//______________________________________________________________________________
}





