//______________________________________________________________________________

//	The Java Virtual Shelf
//______________________________________________________________________________

package org.demo.webwader.gui;

import javax.swing.*;
import java.net.*;
import java.io.InputStream;
import org.ariane.tools.ToolBox;

/**
 * A displayer based on the Swing components.
 * <Br>
 * The window is provided by the WebWindow object.
 * It is the local version. This displayer is also available remotely.
 *
 * @version $Id: SwingDisplayer.java,v 3.7 2001/01/13 18:28:52 lefevre Exp $
 * @author Jean-Paul Le Fvre
 * @see WebWindow
 * @see org.demo.webwader.rbi.SwingDisplayer
 */
//______________________________________________________________________________

public class SwingDisplayer extends AbstractDisplayer {
  /**
   * @serial The unique instance.
   */
private  static SwingDisplayer displayer = null;
  /**
   * @serial The associated window.
   */
private  WebWindow window;
    /**
     * @serial The name of this tool.
     */
public static final String NAME = "LocalSwing";

//______________________________________________________________________________
/**
 * Gets an unique instance of the displayer.
 * <Br>
 * It is a singleton
 * @return the unique instance.
 */
protected static SwingDisplayer instance()
  {
    if(displayer == null) displayer = new SwingDisplayer();

    return displayer;
  }
//______________________________________________________________________________
/**
 * Creates the SwingDisplayer.
 * <Br>
 * It create the WebWindow.
 */
private SwingDisplayer()
  {
      window = WebWindow.instance();
  }
//______________________________________________________________________________
/**
 * Activates this displayer.
 * <br>
 * Actually, it does not need any activation.
 */
final public void activate()
{
    try {
	displayPage(new URL(GuiResources.getWelcomeLocation()));
    }
    catch(Exception ex) {
	ToolBox.warn("Can't display welcome page", ex);
	return;
    }
}
//______________________________________________________________________________
/**
 * Displays the specified document.
 * @param url the url of the page.
 * @return true is the page has been displayed.
 */
final public boolean displayPage(URL url)
{
    if(url == null) {
	window.writeText("Nothing to display !");
	return false;
    }
    else if(! isToShow(url)) {
	if(ToolBox.debug) ToolBox.warn(url.toString() + " not shown");
	return false;
    }

    try {
	String protocol = url.getProtocol();

	if(protocol.equals("file")) {
	   window.display(url.openStream(), url);
	   return true;
	}

	HttpURLConnection c = (HttpURLConnection)url.openConnection();
	c.setRequestMethod("GET");
	InputStream in = c.getInputStream();
	window.display(in, url);
    }
    catch(Exception ex) {
	window.writeText("Can't display " + url);
	if(ToolBox.debug) ToolBox.warn("Can't display " + url, ex);
	return false;
    }

    return true;
}
//______________________________________________________________________________
/**
 * Returns the name of this tool.
 * @return the string.
 */
final public String getName()
{
    return NAME;
}
//______________________________________________________________________________
}


