//______________________________________________________________________________

//	The Java Virtual Shelf
//______________________________________________________________________________

package org.demo.webwader.gui;

import org.ariane.tools.ToolBox;
import org.demo.webwader.Resources;
import org.ariane.exec.ExecutionException;
import java.net.*;
import java.io.*;

/**
 * A displayer sending the URL to display on a socket.
 * <p>
 * It writes the URL to a socket. If a server is listening it
 * will handle the incoming URL. The connection is specified
 * by the port number. The host is the localhost.
 * <br>
 * The Motif application
 * <code>XjShowURL</code> can be used to check this displayer.
 *
 * @version $Id: SocketDisplayer.java,v 1.3 2001/01/15 16:37:00 lefevre Exp $
 * @author Jean-Paul Le Fvre
 * @see org.demo.webwader.SendURL
 */
//______________________________________________________________________________

class SocketDisplayer extends AbstractDisplayer {
  /**
   * @serial The port identifying the connection.
   */
private int port;
  /**
   * @serial The unique instance.
   */
private  static SocketDisplayer displayer = null;
    /**
     * @serial The name of this tool.
     */
protected static final String NAME = "Amaya";

//______________________________________________________________________________
/**
 * Gets an unique instance of the displayer.
 * <Br>
 * It is a singleton
 * @return the unique instance.
 */
protected static SocketDisplayer instance()
  {
    if(displayer == null) displayer = new SocketDisplayer();

    return displayer;
  }
//______________________________________________________________________________
/**
 * Creates the displayer.
 */
protected SocketDisplayer()
  {
  }
//______________________________________________________________________________
/**
 * Activates this displayer.
 * <br>
 * It displays the WebWader welcome page.
 * @see #displayPage
 */
final public void activate()
{
    String cmd = "";
    try {
	Resources rsrc = (org.demo.webwader.Resources)Resources.instance();
	port = rsrc.get(Resources.PREFIX + "Socket.Port", 8333);

	URL welcome = new URL(rsrc.getWelcomeLocation());

	if(! displayPage(welcome)) {
	    throw new ExecutionException("Can't display welcome page");
	}
    }
    catch(Exception ex) {
	ToolBox.warn("Can't activate " + getName(), ex);
	ErrorWindow.instance().display(
	"Can't activate Socket !\nCheck if it is running and try again.");

	throw new ExecutionException("Socket activation failed");
    }
}
//______________________________________________________________________________
/**
 * Displays the specified page with a server.
 * <Br>
 * @param url the url of the page.
 * @return true is the page has been displayed.
 * @see #isToShow
 * @see Socket
 */
final public boolean displayPage(URL url)
{
    try {
	if(! isToShow(url)) return false;

	Socket socket = new Socket("localhost", port);

	BufferedOutputStream out = new BufferedOutputStream(
				     socket.getOutputStream());
	String msg = url.toExternalForm();
	out.write(msg.getBytes() , 0, msg.length());
	out.flush();
	out.close();
    }
    catch(Exception ex) {
	ToolBox.warn("Can't display page", ex);
	return false;
    }

    return true;
}
//______________________________________________________________________________
/**
 * Returns the name of this tool.
 * @return the string.
 */
final public String getName()
{
    return NAME;
}
//______________________________________________________________________________
}


