//______________________________________________________________________________

//	The Java Virtual Shelf
//______________________________________________________________________________

package org.demo.webwader.gui;

import java.net.*;
import org.ariane.tools.ToolBox;
import org.ariane.exec.ExecutionException;

/**
 * A displayer launching SkipStone.
 * <Br>
 * Since version 0.7.3 the patched version of SkipStone
 * is no longer necessary : the option <code>-x</code> has been
 * implemented.
 * It uses @{link java.lang.Runtime#exec() <code>Runtime#exec()</code>
 * to run <code>skipstone -x url</code>.
 *
 * @version $Id: SkipStone.java,v 3.5 2001/06/15 09:28:34 lefevre Exp $
 * @author Jean-Paul Le Fvre
 * @see NavePane
 */
//______________________________________________________________________________

class SkipStone extends AbstractDisplayer {
  /**
   * @serial The unique instance.
   */
private  static SkipStone displayer = null;
    /**
     * @serial The name of this tool.
     */
protected static final String NAME = "SkipStone";

//______________________________________________________________________________
/**
 * Gets an unique instance of the displayer.
 * <Br>
 * It is a singleton
 * @return the unique instance.
 */
protected static SkipStone instance()
  {
    if(displayer == null) displayer = new SkipStone();

    return displayer;
  }
//______________________________________________________________________________
/**
 * Activates SkipStone.
 * <br>
 * In fact the program must be started manually otherwise option
 * <code>-x</code> does not work.
 */
final public void activate()
{
    try {
	ErrorWindow.instance().display("SkipStone must be lauched manually !");
    }
    catch(Exception ex) {
	ToolBox.warn("Can't activate SkipStone", ex);
	if(ToolBox.debug) ex.printStackTrace();
	throw new ExecutionException("SkipStone activation failed");
    }
}
//______________________________________________________________________________
/**
 * Returns the name of this tool.
 * @return the string.
 */
final public String getName()
{
    return NAME;
}
//______________________________________________________________________________
/**
 * Displays the specified page.
 * <Br>
 * @param url the url of the page.
 * @return true is the page has been displayed.
 * @see #isToShow
 * @see java.lang.Runtime
 */
final public boolean displayPage(URL url)
{
    try {
	if(! isToShow(url)) return false;

	String cmd  = "skipstone -x " + url.toExternalForm();
	Process job = Runtime.getRuntime().exec(cmd);

	int rc = 0;
	try {
	    rc  = job.exitValue();
	}
	catch(IllegalThreadStateException ex) {
	    /**
	     * It's OK : it means that the subprocess, i.e. mozilla,
	     * is running.
	     */
	    return true;
	}
	if(rc != 0) {
	    ErrorWindow.instance().display(
	    "Can't run SkipStone !\nCheck if it is running.");
	    return false;
	}
    }
    catch(Exception ex) {
	ToolBox.warn("Can't display page with SkipStone", ex);
	ex.printStackTrace();
	return false;
    }

    return true;
}
//______________________________________________________________________________
}


