//______________________________________________________________________________

//	The Java Virtual Shelf
//______________________________________________________________________________

package org.demo.webwader.gui;
import org.ariane.tools.Couple;

/**
 * A convenient object used by the combo box of the scan pane.
 * <Br>
 * The first member of the couple is the name of a site, the second one
 * is the associated url.
 *
 * @version $Id: SiteRef.java,v 3.1 2000/10/25 16:15:05 lefevre Exp $
 * @author Jean-Paul Le Fvre
 * @see ScanPane
 */
//______________________________________________________________________________

public class SiteRef extends Couple {

//______________________________________________________________________________
/**
 * Creates the SiteRef.
 * @param name the name of the site.
 * @param url the url of the site.
 */
protected SiteRef(String name, String url)
  {
      super(name, url);
  }
//______________________________________________________________________________
/**
 * Returns the content of this object.
 * @return a string giving the name and the url.
 */
final protected String getReference()
{
    return getName() + " " + getURL();
}
//______________________________________________________________________________
/**
 * Returns the name of the site.
 * @return the name.
 */
final public String toString()
{
    return o1.toString();
}
//______________________________________________________________________________
/**
 * Returns the name of the site.
 * @return the name.
 */
final protected String getName()
{
    return o1.toString();
}
//______________________________________________________________________________
/**
 * Returns the url of the site.
 * @return the url.
 */
final protected String getURL()
{
    return o2.toString();
}
//______________________________________________________________________________
/**
 * Changes the url of the site.
 * @param the url.
 */
final protected void setURL(String url)
{
    o2 = url;
}
//______________________________________________________________________________
}


