//______________________________________________________________________________

//	The Java Virtual Shelf
//______________________________________________________________________________

package org.demo.webwader.gui;

import javax.swing.filechooser.FileFilter;
import java.io.File;
import org.ariane.tools.ToolBox;
import org.demo.webwader.WebSite;

/**
 * A customized file filter for WebSite description file.
 * <Br>
 * Such a file may be a plain <code>.site</code> file or a
 * <code>.xml</code> file.
 *
 * @see FileChooser
 * @version $Id: SiteFileFilter.java,v 3.2 2000/11/05 18:26:54 lefevre Exp $
 * @author Jean-Paul Le Fvre
 */
//______________________________________________________________________________

public class SiteFileFilter extends FileFilter {
  /**
   * @serial The unique instance.
   */
private  static SiteFileFilter filter = null;

//______________________________________________________________________________
/**
 * Gets an unique instance of the filter.
 * <Br>
 * It is a singleton
 * @return the unique instance.
 */
protected static SiteFileFilter instance()
  {
    if(filter == null) filter = new SiteFileFilter();

    return filter;
  }
//______________________________________________________________________________
/**
 * Creates the FileFilter.
 */
private SiteFileFilter()
  {
  }
//______________________________________________________________________________
/**
 * Checks if the specified file can be accepted.
 * <br>
 * Site extensions are : <code>.site, .xml</code> (case insensitive).
 * XML is accepted if a parser is available.
 * @param f the file to check.
 * @return true if the file is acceptable.
 */
public boolean accept(File f)
  {
      if(f.isDirectory()) return true;

      String ext = null;
      String s   = f.getName();
      int i = s.lastIndexOf('.');

      if(i < 1) return false;
      s = s.substring(i);
      boolean ok = s.equalsIgnoreCase(WebSite.SUFFIX);

      if(ToolBox.hasXML())
	  return ok || s.equalsIgnoreCase(".xml");
      else
	  return ok; 
  }
//______________________________________________________________________________
/**
 * Provides a description of the filter.
 * @return a phrase describing the filter.
 */
public String getDescription()
  {
      return "WebSite description files";
  }
//______________________________________________________________________________
}


