//______________________________________________________________________________

//	Java Virtual Shelf
//______________________________________________________________________________

package org.demo.webwader.gui;

import org.ariane.tools.TryProg;
import org.ariane.tools.ToolBox;

/**
 * dumps the set of resources availables to the webwader.
 * <P>
 * <Code>
 * Usage : java org.demo.webwader.gui.ShowProperties [-v|d|q][-V][-h]
 * </Code>
 * @see GuiResources
 * @version $Id: ShowProperties.java,v 3.1 2000/10/25 16:15:05 lefevre Exp $
 * @author  Jean-Paul Le Fvre
 */
public class ShowProperties extends TryProg {

//______________________________________________________________________________
    /**
     * The main program.
     * @param args the command line.
     */
public static void main (String[] args)
  {
      ToolBox.debug        = true;
      ToolBox.verbose      = true;
      ShowProperties prog  = new ShowProperties();

      if (! prog.parseArg(args)) {
	  System.err.println("Can't parse command line !");
	  exitWrong();
      }
      if (! prog.run()) {
	  System.err.println("Can't execute ShowProperties !");
	  exitWrong();
      }
  }
//______________________________________________________________________________
  /**
   * Creates the program.
   * <Br>
   * It loads the properties used in the application : the default JVS
   * values, the general WebWader values and the user values.
   */
public ShowProperties()
  {
      super("ShowProperties");
      setResources();
  }
//______________________________________________________________________________
/**
 * Installs the specific resources.
 * @see	org.demo.webwader.Resources
 */
protected void setResources()
  {
      resources = org.demo.webwader.Resources.instance();
  }
//______________________________________________________________________________
    /**
     * dumps the properties.
     * @return true.
     */
public	boolean run()
  {
      resources.dump();
      return true;
  }
//______________________________________________________________________________
    /**
     * Prints how to use the program.
     */
private	void printUsage()
  {
      System.out.println(
      "Usage   : java org.demo.webwader.gui.ShowProperties [options]");
      System.out.println(
      "Options : [-v|-d|-q][-V][-h]");
  }
//______________________________________________________________________________
    /**
     * Parses the command line.
     * <Br>
     * <Code>Usage   : -v|d|q -V -h</Code>
     * @return true if the command line is correct.
     */
public	boolean parseArg(String args[])
  {
    int i          = 0;
    int error      = 0;

    while(i < args.length && args[i].startsWith("-")) {

      String arg = args[i++];
      int j;

      for (j = 1; j < arg.length(); j++) {

	char flag = arg.charAt(j);

	switch (flag) {
	case 'V':
	  org.demo.webwader.VersionInfo.print();
	  break;

	case 'v':
	  ToolBox.verbose = true;
	  ToolBox.debug   = false;
	  break;

	case 'd':
	  ToolBox.verbose = true;
	  ToolBox.debug   = true;
	  break;

	case 'q':
	  ToolBox.verbose = false;
	  ToolBox.debug   = false;
	  break;

	default	:
	  printUsage();
	  error++;
	  break;
	}
      }
    }

    return (error == 0);
  }
//______________________________________________________________________________
}

