//______________________________________________________________________________

//	The Java Virtual Shelf
//______________________________________________________________________________

package org.demo.webwader.gui;

import java.io.*;
import javax.swing.*;
import javax.swing.border.Border;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.*;
import javax.swing.event.*;

import org.ariane.tools.ToolBox;
import org.ariane.tools.Resources;
import org.ariane.gui.ConsoleWriter;

/**
 * A customized Dialog used to scan a web site.
 * <Br>
 * @version $Id: ScanWindow.java,v 3.5 2001/01/07 13:18:39 lefevre Exp $
 * @author Jean-Paul Le Fvre
 */
//______________________________________________________________________________

class ScanWindow extends Dialog {
  /**
   * @serial The unique instance.
   */
private  static ScanWindow window = null;
  /**
   * @serial The text pane.
   */
private JTextArea text_pane;
  /**
   * @serial The scan pane.
   */
private ScanPane scan_pane;
    /**
     * @serial The printer to the console.
     */
private	PrintWriter  printer;
    /**
     * @serial The height of the text.
     */
private	int  text_height = -1;

//______________________________________________________________________________
/**
 * Gets an unique instance of the window.
 * <Br>
 * It is a singleton
 * @return the unique instance.
 */
protected static ScanWindow instance()
  {
    if(window == null) window = new ScanWindow();

    return window;
  }
//______________________________________________________________________________
/**
 * Creates the ScanWindow.
 * <Br>
 * It is a non modal dialog window.
 * It installs actions to be performed when the window is hidden or closed.
 */
private ScanWindow()
  {
      super("Scan Dialog  ", "jvs.gif", false);
      ok_button.setToolTipText(
		"To make this site current and close the window");
      cancel_button.setToolTipText("To stop the scan and close the window");


      /**
       * Process a Button pressed.
       */
      class Listener implements ActionListener {
	  final public void actionPerformed(ActionEvent ev) {
	      processAction(ev.getActionCommand());
	  }
      }

      Listener listener = new Listener();
      ok_button.addActionListener(listener);
      cancel_button.addActionListener(listener);

      /**
       * Process a close operation.
       */
      class Adapter extends WindowAdapter {
	  final public void windowClosed(WindowEvent ev) {
		  processAction("Closed");
	  }
	  final public void windowClosing(WindowEvent ev)  {
		  processAction("Closing");
	  }
      }

      addWindowListener(new Adapter());
  }
//______________________________________________________________________________
/**
 * Builds the main component.
 * @return the component.
 */
protected JComponent createComponent()
{
    JPanel panel = new JPanel();
    panel.setLayout(new BoxLayout(panel, BoxLayout.Y_AXIS));

    setInitialSize("ScanWindow", 600, 600);

    JComponent board = createBoard();
    panel.add(board);

    JComponent console = createConsole();
    panel.add(console);

    return panel;
}
//______________________________________________________________________________
/**
 * Builds the scanner board.
 * <Br>
 * @return the built component.
 */
private JComponent createBoard()
  {
      JPanel board    = new JPanel();

      board.setBackground(resources.getPaneBackground());
      board.setLayout(new BoxLayout(board, BoxLayout.X_AXIS));
      board.setOpaque(true);
      Border border = BorderFactory.createCompoundBorder(
      resources.getMatteBorder(), resources.getLineBorder());
      board.setBorder(border);

      scan_pane = ScanPane.instance();
      scan_pane.setAlignmentX(Component.LEFT_ALIGNMENT);
      board.add(scan_pane);

      board.add(Box.createHorizontalGlue());

      return board;
  }
//______________________________________________________________________________
/**
 * Builds the messages area.
 * @return the component.
 */
private JComponent createConsole()
{
    text_pane    = new JTextArea();

    text_pane.setEditable(false);
    text_pane.setOpaque(true);
    text_pane.setBackground(resources.getBoardBackground());
    text_pane.setForeground(resources.getBoardForeground());
    text_pane.setFont(resources.getTextFont());
    text_pane.setText(writeText());

    JScrollPane scroll = new JScrollPane(text_pane);
    Border border = BorderFactory.createCompoundBorder(
    resources.getMatteBorder(), resources.getLineBorder());
    scroll.setBorder(border);

    /**
     * Reacts to a change in the view.
     */
    class Listener implements ChangeListener {
	  public void stateChanged(ChangeEvent ev) {
	      updateViewport((JViewport)ev.getSource());
	  }
      }
    scroll.getViewport().addChangeListener(new Listener());

    return scroll;
}
//______________________________________________________________________________
/**
 * Updates the view.
 * <P>
 * Scolling is performed in order to always see the bottom of the text.
 */
final private void updateViewport(JViewport viewport)
{
    int htext = text_pane.getHeight();
    if(text_height ==  htext) return; 		// The text has not changed

    text_height = htext;
    int hview   = viewport.getExtentSize().height;

    if(htext <= hview) return;        	       // The text is smaller
    int y = htext - hview;

    viewport.setViewPosition(new Point(0, y));	// Move the view
}
//______________________________________________________________________________
/**
 * Gets a printer to the text area.
 * @return the printer to the console.
 * @see ConsoleWriter
 */
final protected PrintWriter getConsolePrinter()
{
    if(printer == null) {
      ConsoleWriter writer = new ConsoleWriter(text_pane.getDocument());
      printer = new PrintWriter(writer);
    }

    return printer;
}
//______________________________________________________________________________
/**
 * Erases to the text area.
 * @see JTextArea#setText
 */
final protected void clearConsole()
{
    text_pane.setText(null);
}
//______________________________________________________________________________
/**
 * Creates a text to be displayed.
 * @return the string.
 */
final private String writeText()
{
    return "Waiting for a command !";
}
//______________________________________________________________________________
/**
 * Processes the command when a button is pressed.
 * <Br>
 * If the button OK is pressed the newly scanned is passed
 * to the rest of the application.
 * @param cmd the command issued by the button.
 */
final private void processAction(String cmd)
{
    if(cmd.equals(OK)) {
	Controller.instance().setNewWebSite(scan_pane.getWebSite());
    }
    scan_pane.killScan();
}
//______________________________________________________________________________
}


