//______________________________________________________________________________

//	The Java Virtual Shelf
//______________________________________________________________________________

package org.demo.webwader.gui;

import org.ariane.tools.ToolBox;

/**
 * A displayer used to communicate with the remote browser Swing.
 * <br>
 * @version $Id: RemoteSwingDisplayer.java,v 1.2 2001/01/13 18:31:01 lefevre Exp $
 * @author Jean-Paul Le Fvre
 * @see NavePane
 */
//______________________________________________________________________________

class RemoteSwingDisplayer extends JavaDisplayer {
  /**
   * @serial The unique instance.
   */
private  static RemoteSwingDisplayer instance = null;
    /**
     * @serial The name of this tool.
     */
protected static final String NAME = org.demo.webwader.rbi.SwingDisplayer.NAME;

//______________________________________________________________________________
/**
 * Gets an unique instance of the displayer.
 * <Br>
 * It is a singleton
 * @return the unique instance.
 */
protected static RemoteSwingDisplayer instance()
  {
    if(instance == null) instance = new RemoteSwingDisplayer();

    return instance;
  }
//______________________________________________________________________________
/**
 * Creates the displayer.
 */
private RemoteSwingDisplayer()
  {
      super();
  }
//______________________________________________________________________________
/**
 * Returns the name of this tool.
 * @return the string.
 */
final public String getName()
{
    return NAME;
}
//______________________________________________________________________________
}


