//______________________________________________________________________________

//	The Java Virtual Shelf
//______________________________________________________________________________

package org.demo.webwader.gui;

import org.ariane.tools.ToolBox;
import org.demo.webwader.Resources;
import java.net.URL;
import java.io.*;

/**
 * A displayer used to test the Windows DDE displayers.
 * <Br>
 * It uses @{link Runtime.exec()} to run <Code>print_url</Code> which is
 * expected to be in $JVS_HOME/bin.
 *
 * @version $Id: PrintURL.java,v 3.8 2001/01/07 13:17:45 lefevre Exp $
 * @author Jean-Paul Le Fvre
 * @see WebWindow
 */
//______________________________________________________________________________

class PrintURL extends AbstractDisplayer {
  /**
   * @serial The unique instance.
   */
private  static PrintURL displayer = null;
  /**
   * @serial The path to the command + a white space.
   */
private  static String command = null;
    /**
     * @serial The name of this tool.
     */
protected static final String NAME = "PrintURL";

//______________________________________________________________________________
/**
 * Gets an unique instance of the displayer.
 * <Br>
 * It is a singleton
 * @return the unique instance.
 */
protected static PrintURL instance()
  {
    if(displayer == null) displayer = new PrintURL();

    return displayer;
  }
//______________________________________________________________________________
/**
 * Creates the displayer.
 * <Br>
 * The path to the command is built.
 */
private PrintURL()
  {
      String jvs_bin  = Resources.instance().getBinDirectory();
      command         = jvs_bin + "print_url";
      if(ToolBox.isUnderWindows()) {
	  command += ".exe";
      }

      File file       = new File(command);
      if(! file.exists()) {
	  ToolBox.warn("Can't find " + command);
	  command = null;
	  return;
      }
      ToolBox.warn("Program " + command);
      command += " ";
  }
//______________________________________________________________________________
/**
 * Activates this displayer.
 */
final public void activate()
{
    if(command == null) {
	ErrorWindow.instance().display("Can't activate PrintURL !");
	return;
    }

    try {
	displayPage(new URL(GuiResources.getWelcomeLocation()));
    }
    catch(Exception ex) {
	ToolBox.warn("Can't display welcome page", ex);
	return;
    }
}
//______________________________________________________________________________
/**
 * Returns the name of this tool.
 * @return the string.
 */
final public String getName()
{
    return NAME;
}
//______________________________________________________________________________
/**
 * Displays the specified page.
 * <Br>
 * Actually, the page is not displayed. Only its URL is printed on standard
 * output. This displayer is meant to simulate DDE on Linux.
 * @param url the url of the page.
 * @return true is the page has been displayed.
 * @see Runtime
 */
final public boolean displayPage(URL url)
{
    if(url == null) {
	return false;
    }
    else if(! isToShow(url)) {
	if(ToolBox.debug) ToolBox.warn(url.toString() + " not shown");
	return false;
    }

    try {
	Process job = Runtime.getRuntime().exec(command + url.toExternalForm());
	job.waitFor();

	BufferedReader br = new BufferedReader(
			    new InputStreamReader(job.getInputStream()));
	System.out.println(br.readLine());
    }
    catch(Exception ex) {
	ToolBox.warn("Can't display page " + url, ex);
	if(ToolBox.debug) ex.printStackTrace();
	return false;
    }

    return true;
}
//______________________________________________________________________________
}





