//______________________________________________________________________________

//	The Java Virtual Shelf
//______________________________________________________________________________

package org.demo.webwader.gui;

import org.ariane.tools.ToolBox;
import org.ariane.tools.Resources;
import java.net.URL;
import java.io.File;

/**
 * A displayer used to communicate with Opera under Windows.
 * <Br>
 * It uses @{link Runtime.exec()} to run <Code>open_url</Code> which is
 * expected to be in $JVS_HOME\\bin.
 *
 * @version $Id: OperaWindows.java,v 3.2 2000/10/25 16:15:05 lefevre Exp $
 * @author Jean-Paul Le Fvre
 * @see NavePane
 */
//______________________________________________________________________________

class OperaWindows extends BrowserWindows {
  /**
   * @serial The unique instance.
   */
private  static OperaWindows displayer = null;
    /**
     * @serial The name of this tool.
     */
protected static final String NAME = "Opera";

//______________________________________________________________________________
/**
 * Gets an unique instance of the displayer.
 * <Br>
 * It is a singleton
 * @return the unique instance.
 */
protected static OperaWindows instance()
  {
    if(displayer == null) displayer = new OperaWindows();

    return displayer;
  }
//______________________________________________________________________________
/**
 * Creates the displayer.
 */
private OperaWindows()
  {
      super();
  }
//______________________________________________________________________________
/**
 * Returns the name of this tool.
 * @return the string.
 */
final public String getName()
{
    return NAME;
}
//______________________________________________________________________________
/**
 * Returns the path to Opera.
 * <br>
 * It is searched in the property : "OperaWindows.Path"
 * @return the path.
 */
final public String getPath()
{
    return Resources.instance().get("OperaWindows.Path",
    "C:\\Program Files\\Opera\\Opera.exe");
}
//______________________________________________________________________________
/**
 * Returns the flag used to launch Opera.
 * @return the string.
 */
final protected String getOptions()
{
    return "-o";
}
//______________________________________________________________________________
}


