//______________________________________________________________________________

//	The Java Virtual Shelf
//______________________________________________________________________________

package org.demo.webwader.gui;

import java.net.*;
import org.ariane.tools.ToolBox;
import org.ariane.exec.ExecutionException;

/**
 * A displayer using the remote facility of Opera on Unix.
 * <Br>
 * It uses @{link Runtime.exec()} to run
 * <Code>opera -remote openURL(url)</Code>.
 *
 * @version $Id: OperaUnix.java,v 3.1 2001/02/14 20:56:30 lefevre Exp $
 * @author Jean-Paul Le Fvre
 * @see NavePane
 * @see OperaWindows
 */
//______________________________________________________________________________

class OperaUnix extends AbstractMozillaUnix {
  /**
   * @serial The unique instance.
   */
private  static OperaUnix displayer = null;
    /**
     * @serial The name of this tool.
     */
protected static final String NAME = "Opera";

//______________________________________________________________________________
/**
 * Gets an unique instance of the displayer.
 * <Br>
 * It is a singleton
 * @return the unique instance.
 */
protected static OperaUnix instance()
  {
    if(displayer == null) displayer = new OperaUnix();

    return displayer;
  }
//______________________________________________________________________________
/**
 * Returns the name of this tool.
 * @return the string.
 */
final public String getName()
{
    return NAME;
}
//______________________________________________________________________________
/**
 * Returns the name of the program.
 * @return the string.
 */
final protected String getCommand()
{
    return "opera ";
}
//______________________________________________________________________________
/**
 * Activates the browser.
 * <br>
 * Opera accepts the option <code>-remote </code> even if it is not
 * already running.
 */
final public void activate()
{
    // /opt/JVS/lib/webwader-welcome.html
    String welcome = GuiResources.getWelcomeLocation();

    // mozilla -remote openURL(/opt/JVS/lib/webwader-welcome.html)
    StringBuffer buf =
    new StringBuffer(getCommand()).append("-remote openURL(");
    buf.append(welcome).append(")");

    String cmd  = buf.toString();

    try {
	/**
	 * Use the -remote option.
	 */
	int rc = 0;
	Process job = Runtime.getRuntime().exec(cmd);
	try {
	    rc = job.exitValue();
	}
	catch(IllegalThreadStateException ex) {
	    /**
	     * It's OK : it means that the subprocess, i.e. opera,
	     * is running.
	     */
	    return;
	}

	ErrorWindow.instance().display("Can't launch opera !");
	if(ToolBox.debug) ToolBox.warn(cmd + " rc : " + rc);
    }
    catch(Exception ex) {
	ToolBox.warn("Can't activate the browser", ex);
	if(ToolBox.debug) ex.printStackTrace();
	throw new ExecutionException("Opera activation failed");
    }
}
//______________________________________________________________________________
}


