//______________________________________________________________________________

//	The Java Virtual Shelf
//______________________________________________________________________________

package org.demo.webwader.gui;

import org.ariane.tools.ToolBox;
import org.ariane.tools.Resources;
import java.net.URL;
import java.io.File;

/**
 * A displayer used to communicate with Netscape under Windows.
 * <Br>
 * It uses @{link Runtime.exec()} to run <Code>open_url</Code> which is
 * expected to be in $JVS_HOME\\bin.
 *
 * @version $Id: NetscapeWindows.java,v 3.2 2000/10/25 16:15:05 lefevre Exp $
 * @author Jean-Paul Le Fvre
 * @see NavePane
 */
//______________________________________________________________________________

class NetscapeWindows extends BrowserWindows {
  /**
   * @serial The unique instance.
   */
private  static NetscapeWindows displayer = null;
    /**
     * @serial The name of this tool.
     */
protected static final String NAME = "Netscape";

//______________________________________________________________________________
/**
 * Gets an unique instance of the displayer.
 * <Br>
 * It is a singleton
 * @return the unique instance.
 */
protected static NetscapeWindows instance()
  {
    if(displayer == null) displayer = new NetscapeWindows();

    return displayer;
  }
//______________________________________________________________________________
/**
 * Creates the displayer.
 * <Br>
 * The path to the command <Code>open_url.exe -n</Code> is built.
 */
private NetscapeWindows()
  {
      super();
  }
//______________________________________________________________________________
/**
 * Returns the name of this tool.
 * @return the string.
 */
final public String getName()
{
    return NAME;
}
//______________________________________________________________________________
/**
 * Returns the path to Netscape.
 * <br>
 * It is searched in the property : "NetscapeWindows.Path"
 * @return the path.
 */
final public String getPath()
{
    return Resources.instance().get("NetscapeWindows.Path",
    "C:\\Program Files\\Netscape\\Communicator\\Program\\netscape.exe");
}
//______________________________________________________________________________
/**
 * Returns the flag used to launch Netscape.
 * @return the string.
 */
final protected String getOptions()
{
    return "-n";
}
//______________________________________________________________________________
}


