//______________________________________________________________________________

//	The Java Virtual Shelf
//______________________________________________________________________________

package org.demo.webwader.gui;

import java.net.*;
import org.ariane.tools.ToolBox;
import org.ariane.exec.ExecutionException;

/**
 * A displayer using the remote facility of Netscape on Unix.
 * <Br>
 * It uses @{link Runtime.exec()} to run
 * <Code>netscape -remote openURL(url)</Code>.
 *
 * @version $Id: NetscapeUnix.java,v 3.8 2001/01/13 18:32:17 lefevre Exp $
 * @author Jean-Paul Le Fvre
 * @see NavePane
 * @see BrowserWindows
 */
//______________________________________________________________________________

class NetscapeUnix extends AbstractMozillaUnix {
  /**
   * @serial The unique instance.
   */
private  static NetscapeUnix displayer = null;
    /**
     * @serial The name of this tool.
     */
protected static final String NAME = "Netscape";

//______________________________________________________________________________
/**
 * Gets an unique instance of the displayer.
 * <Br>
 * It is a singleton
 * @return the unique instance.
 */
protected static NetscapeUnix instance()
  {
    if(displayer == null) displayer = new NetscapeUnix();

    return displayer;
  }
//______________________________________________________________________________
/**
 * Returns the name of this tool.
 * @return the string.
 */
final public String getName()
{
    return NAME;
}
//______________________________________________________________________________
/**
 * Returns the name of the program.
 * @return the string.
 */
final protected String getCommand()
{
    return "netscape ";
}
//______________________________________________________________________________
}


