//______________________________________________________________________________

//	The Java Virtual Shelf
//______________________________________________________________________________

package org.demo.webwader.gui;

import org.ariane.tools.ToolBox;
import org.ariane.tools.Resources;
import java.net.URL;
import java.io.File;

/**
 * A displayer used to communicate with NeoPlanet under Windows.
 * <Br>
 * It uses @{link Runtime.exec()} to run <Code>open_url</Code> which is
 * expected to be in $JVS_HOME\\bin.
 *
 * @version $Id: NeoPlanet.java,v 3.1 2001/02/05 20:34:02 lefevre Exp $
 * @author Jean-Paul Le Fvre
 * @see NavePane
 */
//______________________________________________________________________________

class NeoPlanet extends BrowserWindows {
  /**
   * @serial The unique instance.
   */
private  static NeoPlanet displayer = null;
    /**
     * @serial The name of this tool.
     */
protected static final String NAME = "NeoPlanet";

//______________________________________________________________________________
/**
 * Gets an unique instance of the displayer.
 * <br>
 * It is a singleton
 * @return the unique instance.
 */
protected static NeoPlanet instance()
  {
    if(displayer == null) displayer = new NeoPlanet();

    return displayer;
  }
//______________________________________________________________________________
/**
 * Creates the displayer.
 */
private NeoPlanet()
  {
      super();
  }
//______________________________________________________________________________
/**
 * Returns the name of this tool.
 * @return the string.
 */
final public String getName()
{
    return NAME;
}
//______________________________________________________________________________
/**
 * Returns the path to NeoPlanet.
 * <br>
 * It is searched in the property : "NeoPlanet.Path".
 * @return the path.
 */
final public String getPath()
{
    return Resources.instance().get("NeoPlanet.Path",
           "C:\\Program Files\\NeoPlanet\\bin\\NP.exe");
}
//______________________________________________________________________________
/**
 * Returns the flag used to launch NeoPlanet.
 * @return the string.
 */
final protected String getOptions()
{
    return "--name " + NAME;
}
//______________________________________________________________________________
}


