//______________________________________________________________________________

//	The Java Virtual Shelf
//______________________________________________________________________________

package org.demo.webwader.gui;

import javax.swing.*;
import java.awt.*;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.border.Border;
import org.ariane.tools.ToolBox;

/**
 * The mini window presenting the navigation buttons.
 * @version $Id: NaveBoard.java,v 3.5 2000/10/25 16:15:05 lefevre Exp $
 * @author Jean-Paul Le Fvre
 */
//______________________________________________________________________________

class NaveBoard extends JWindow {
  /**
   * @serial The unique instance.
   */
private static NaveBoard  nave_board = null;
    /**
     * @serial the button Previous.
     */
protected JButton prev_button;
    /**
     * @serial the button Next.
     */
private JButton next_button;
  /**
   * @serial A mode button.
   */
private JRadioButton auto_button;
  /**
   * @serial A mode button.
   */
private JRadioButton manual_button;
  /**
   * @serial the resources.
   */
private GuiResources rsrc;
  /**
   * @serial The previous button icon.
   */
private Icon prev_icon;
  /**
   * @serial The next button icon.
   */
private Icon next_icon;
  /**
   * @serial The start button icon.
   */
private Icon start_icon;
  /**
   * @serial The stop button icon.
   */
private Icon stop_icon;

//______________________________________________________________________________
/**
 * Gets an unique instance of the NaveBoard.
 * <Br>
 * It is a singleton.
 * @return the unique instance.
 */
protected static NaveBoard instance()
  {
    if(nave_board == null) nave_board = new NaveBoard();

    return nave_board;
  }
//______________________________________________________________________________
/**
 * Creates the window.
 */
private NaveBoard()
  {
      super(MainFrame.instance());
      build();
      /**
       * Process a close operation.
       */
      class Adapter extends WindowAdapter {
	  final public void windowClosed(WindowEvent ev) {
		  processClose();
	  }
	  final public void windowClosing(WindowEvent ev)  {
		  processClose();
	  }
      }

      addWindowListener(new Adapter());
  }
//______________________________________________________________________________
 /**
  * Builds the window.
  * <br>
  * The buttons are recreated for this board. But the listeners are
  * borrowed to the NavePane.
  */
private void build()
  {
      rsrc = GuiResources.instance();

      setBackground(rsrc.getMainBackground());
      setForeground(rsrc.getMainForeground());

      setLocation(rsrc.get("MiniBoard.X", 5), rsrc.get("MiniBoard.Y", 10));

      Color fg = rsrc.getPaneForeground();
      Color bg = rsrc.getPaneBackground();

      prev_icon  = rsrc.getIcon("previous.gif");
      next_icon  = rsrc.getIcon("next.gif");
      start_icon = rsrc.getIcon("start.gif");
      stop_icon  = rsrc.getIcon("stop.gif");

      Border border = BorderFactory.createCompoundBorder(
      rsrc.getLineBorder(), rsrc.getOutBorder());

      JPanel box = new JPanel();
      setContentPane(box);
      box.setLayout(new GridLayout(2, 2));

      box.setBackground(bg);
      box.setForeground(fg);
      box.setBorder(border);

      Insets margin   = new Insets(0,0, 0,0);
      Dimension bdim  = new Dimension(30, 30);

      prev_button  =  new JButton(prev_icon);
      prev_button.setToolTipText("Go to previous page");
      prev_button.setOpaque(false);
      prev_button.setBackground(bg);
      prev_button.setMargin(margin);
      prev_button.setActionCommand(NavePane.PREV);
      prev_button.setPreferredSize(bdim);
      box.add(prev_button);

      prev_button.addActionListener(NavePane.instance().getNaveListener());

      next_button  =  new JButton(next_icon);
      next_button.setToolTipText("Go to next page");
      next_button.setOpaque(false);
      next_button.setBackground(bg);
      next_button.setMargin(margin);
      next_button.setActionCommand(NavePane.NEXT);
      next_button.setPreferredSize(bdim);
      box.add(next_button);
      next_button.addActionListener(NavePane.instance().getNaveListener());

      ButtonGroup group  = new ButtonGroup();

      manual_button  = new JRadioButton("M");
      manual_button.setToolTipText("Set manual mode");
      manual_button.setFont(rsrc.getTextFont());
      manual_button.setOpaque(false);
      manual_button.setForeground(fg);
      manual_button.setHorizontalAlignment(JRadioButton.CENTER);
      manual_button.addActionListener(NavePane.instance().getModeListener());

      box.add(manual_button);
      group.add(manual_button);

      auto_button   = new JRadioButton("A");
      auto_button.setToolTipText("Set automatic mode");
      auto_button.setFont(rsrc.getTextFont());
      auto_button.setOpaque(false);
      auto_button.setForeground(fg);
      auto_button.setHorizontalAlignment(JRadioButton.CENTER);
      auto_button.addActionListener(NavePane.instance().getModeListener());
      setMode(NavePane.instance().getMode());

      box.add(auto_button);
      group.add(auto_button);

      pack();
  }
//______________________________________________________________________________
/**
 * Displays the Pane if the option is set.
 * @param todo if true the window is shown, hidden otherwise.
 */
final protected void display(boolean todo)
{
    MainFrame frame = MainFrame.instance();

    if(todo) {
	setVisible(frame.getShowMiniBoardState());
    }
    else {
	setVisible(false);
	frame.setShowMiniBoardState(false);
    }
}
//______________________________________________________________________________
/**
 * Processes the command when the window is closed.
 * @param cmd the command issued by the button.
 */
final private void processClose()
{
    display(false);
}
//______________________________________________________________________________
/**
 * Sets the navigation mode : manual or automatic.
 * <Br>
 * The buttons are updated. The same buttons are used in both modes.
 * <B>Previous</B> is <B>Stop</B> and <B>Next</B> is <B>Start</B>.
 *
 * @param manual, changes to manual if true, to automatic otherwise.
 * @see NavePane#setMode
 */
final protected void setMode(boolean manual)
{
    if(manual) {
	manual_button.setSelected(true);

	prev_button.setIcon(prev_icon);
	prev_button.setToolTipText("Go to previous page");

	next_button.setIcon(next_icon);
	next_button.setToolTipText("Go to next page");

	prev_button.setEnabled(true);
	next_button.setEnabled(true);
    }
    else {
	JButton stop_button  = prev_button;
	JButton start_button = next_button;

	auto_button.setSelected(true);

	stop_button.setIcon(stop_icon);
	stop_button.setToolTipText("Stop navigation in progress");

	start_button.setIcon(start_icon);
	start_button.setToolTipText("Start new navigation");

	start_button.setEnabled(true);
	stop_button.setEnabled(false);
    }
}
//______________________________________________________________________________
/**
 * Updates the status of the button.
 * <Br>
 * @param cmd the command issued by the button.
 * @see NavePane#updateButtonStatus
 */
final protected void updateButtonStatus(String cmd)
{
    /**
     * Update the status of the buttons.
     * When Start is pressed, only Stop is kept sensitive.
     */
    JButton stop_button  = prev_button;
    JButton start_button = next_button;

    if(cmd.equals(NavePane.START)) {
	start_button.setEnabled(false);
	stop_button.setEnabled(true);

	manual_button.setEnabled(false);
	auto_button.setEnabled(false);
    }
    else { // STOP
	start_button.setEnabled(true);
	stop_button.setEnabled(false);

	manual_button.setEnabled(true);
	auto_button.setEnabled(true);
    }
}
//______________________________________________________________________________
}
