//______________________________________________________________________________

//	The Java Virtual Shelf
//______________________________________________________________________________

package org.demo.webwader.gui;

import org.ariane.tools.ToolBox;
import org.ariane.tools.Resources;
import java.net.URL;
import java.io.File;

/**
 * A displayer used to communicate with Mozilla under Windows.
 * <br>
 * It uses @{link Runtime.exec()} to run <Code>open_url</Code> which is
 * expected to be in $JVS_HOME\\bin.
 *
 * @version $Id: MozillaWindows.java,v 3.1 2001/06/19 19:21:12 lefevre Exp $
 * @author Jean-Paul Le Fvre
 * @see NavePane
 */
//______________________________________________________________________________

class MozillaWindows extends BrowserWindows {
  /**
   * @serial The unique instance.
   */
private  static MozillaWindows displayer = null;
    /**
     * @serial The name of this tool.
     */
protected static final String NAME = "Mozilla";

//______________________________________________________________________________
/**
 * Gets an unique instance of the displayer.
 * <Br>
 * It is a singleton
 * @return the unique instance.
 */
protected static MozillaWindows instance()
  {
    if(displayer == null) displayer = new MozillaWindows();

    return displayer;
  }
//______________________________________________________________________________
/**
 * Creates the displayer.
 * <br>
 * The path to the command <Code>open_url.exe -m</Code> is built.
 */
private MozillaWindows()
  {
      super();
  }
//______________________________________________________________________________
/**
 * Returns the name of this tool.
 * @return the string.
 */
final public String getName()
{
    return NAME;
}
//______________________________________________________________________________
/**
 * Returns the path to Mozilla.
 * <br>
 * It is searched in the property : "MozillaWindows.Path"
 * @return the path.
 */
final public String getPath()
{
    return Resources.instance().get("MozillaWindows.Path",
    "C:\\Program Files\\mozilla.org\\Mozilla\\\\mozilla.exe");
}
//______________________________________________________________________________
/**
 * Returns the flag used to launch Mozilla.
 * @return the string.
 */
final protected String getOptions()
{
    return "-m";
}
//______________________________________________________________________________
}


