//______________________________________________________________________________

//	The Java Virtual Shelf
//______________________________________________________________________________

package org.demo.webwader.gui;

import java.net.*;
import org.ariane.tools.ToolBox;
import org.ariane.exec.ExecutionException;

/**
 * A displayer using the remote facility of Mozilla on Unix.
 * <Br>
 * It uses @{link Runtime.exec()} to run
 * <Code>mozilla -remote openURL(url)</Code>.
 *
 * @version $Id: MozillaUnix.java,v 1.2 2001/02/14 20:56:30 lefevre Exp $
 * @author Jean-Paul Le Fvre
 * @see NavePane
 */
//______________________________________________________________________________

class MozillaUnix extends AbstractMozillaUnix {
  /**
   * @serial The unique instance.
   */
private  static MozillaUnix displayer = null;
    /**
     * @serial The name of this tool.
     */
protected static final String NAME = "Mozilla";

//______________________________________________________________________________
/**
 * Gets an unique instance of the displayer.
 * <Br>
 * It is a singleton
 * @return the unique instance.
 */
protected static MozillaUnix instance()
  {
    if(displayer == null) displayer = new MozillaUnix();

    return displayer;
  }
//______________________________________________________________________________
/**
 * Returns the name of this tool.
 * @return the string.
 */
final public String getName()
{
    return NAME;
}
//______________________________________________________________________________
/**
 * Returns the name of the program.
 * @return the string.
 */
final protected String getCommand()
{
    return "mozilla ";
}
//______________________________________________________________________________
}


