//______________________________________________________________________________

//	The Java Virtual Shelf
//______________________________________________________________________________

package org.demo.webwader.gui;

import java.net.*;
import java.io.*;
import org.demo.webwader.Resources;
import org.ariane.tools.ToolBox;
import org.ariane.exec.ExecutionException;
/**
 * A displayer using DCOP to communicate with Konqueror on KDE.
 * <br>
 * See <a href="http://www.konqueror.org">http://www.konqueror.org</a>

 * @version $Id: Konqueror.java,v 3.5 2001/04/05 15:58:16 lefevre Exp $
 * @author Jean-Paul Le Fvre
 * @see NavePane
 * @see EmacsW3
 */
//______________________________________________________________________________

class Konqueror extends AbstractDisplayer {
  /**
   * @serial The unique instance.
   */
private  static Konqueror displayer = null;
  /**
   * @serial The path to the command + a white space.
   */
private String command = null;
    /**
     * @serial The name of this tool.
     */
protected static final String NAME = "Konqueror";

//______________________________________________________________________________
/**
 * Gets an unique instance of the displayer.
 * <Br>
 * It is a singleton
 * @return the unique instance.
 */
protected static Konqueror instance()
  {
    if(displayer == null) displayer = new Konqueror();

    return displayer;
  }
//______________________________________________________________________________
/**
 * Activates Konqueror.
 * <br>
 * It tries to display the WebWader welcome page. If it fails
 * a message is shown. There is no attempt to start automatically
 * the browser.
 * @see #prepareCommand
 */
final public void activate()
{
    String cmd = "";

    try {
	prepareCommand();

	cmd = getCommand(GuiResources.getWelcomeLocation());

	Process job = Runtime.getRuntime().exec(cmd);
	int rc = 0;
	try {
	    rc  = job.exitValue();
	}
	catch(IllegalThreadStateException ex) {
	     // It's OK : it means that the browser is running.
	    return;
	}
	ErrorWindow.instance().display("Can't activate Konqueror !");
	if(ToolBox.debug) ToolBox.warn(cmd + " rc : " + rc);
    }
    catch(Exception ex) {
	ErrorWindow.instance().display(
	"Can't activate Konqueror !\nCheck if it is running and try again.");
	ToolBox.warn("Can't activate Konqueror", ex);
	throw new ExecutionException("Konqueror activation failed");
    }
}
//______________________________________________________________________________
/**
 * Returns the name of this tool.
 * @return the string.
 */
final public String getName()
{
    return NAME;
}
//______________________________________________________________________________
/**
 * Displays the specified page.
 * <Br>
 * For this method to work, Konqueror must be already running.
 * @param url the url of the page.
 * @return true is the page has been displayed.
 * @see #isToShow
 * @see Runtime
 */
final public boolean displayPage(URL url)
{
    String cmd = "";
    try {
	if(! isToShow(url)) return false;

	cmd  = getCommand(url.toExternalForm());
	if(false) ToolBox.warn(cmd);
	Process job = Runtime.getRuntime().exec(cmd);

	int rc = job.waitFor();
	if(rc != 0) {
	    ErrorWindow.instance().display(
	    "Can't run Konqueror !\nCheck if it is running.");
	    return false;
	}
    }
    catch(Exception ex) {
	ToolBox.warn("Can't display page with Konqueror", ex);
	ToolBox.warn("Command : " + cmd);
	if(ToolBox.debug) ex.printStackTrace();
	return false;
    }

    return true;
}
//______________________________________________________________________________
/**
 * Returns the command launching the client.
 * <br>
 * The command must have breen prepared.
 * It is <code>dcop konqueror windom_id openURL url</code>
 * @return the string.
 * @see #prepareCommand
 */
final private String getCommand(String url)
    {
	if(command == null)throw new ExecutionException("Invalid null command");
	return command + url;
    }
//______________________________________________________________________________
/**
 * Initializes the command to display URLs.
 * <br>
 * It is : <code>dcop konqueror windom_id openURL</code>
 * <br>
 * If the property <code>Konqueror.MainWindow</code> is NOT defined,
 * the KDE version is supposed to be lower than 2.1 and the window id
 * is guessed automatically. For newer version of KDE, the window id
 * must be provided in the resources. It is something like
 * <code>konqueror-mainwindow#1</code>
 *
 * @see #getWindowId
 * @see #listWindowIds
 */
final private void prepareCommand()
    {
	String id = Resources.instance().get("Konqueror.MainWindow");
	if(id == null) {
	    id = getWindowId();
	}
	else if(ToolBox.debug) {
	    listWindowIds();
	    System.out.println(id + " is selected");
	}

	command = "dcop konqueror " + id + " openURL ";	
    }
//______________________________________________________________________________
/**
 * Returns the address of the window used to show documents.
 * It runs the following commands :<br>
 * <code>dcop konqueror default getWindows</code><br>
 * <code>dcop konqueror</code><br>
 * Output of the last one is expected to provide the id of a Konqueror window.
 *
 * @return the id as a string.
 * @throw ExecutionException if commands failed.
 * @see #prepareCommand()
 * @see #listWindowIds()
 */
final private String getWindowId()
{
    String cmd = "";
    try {
	cmd = "dcop konqueror default getWindows";
	Process job = Runtime.getRuntime().exec(cmd);

	if(job.waitFor() != 0)
	    throw new ExecutionException("Job " + cmd + " failed");

	cmd = "dcop konqueror";
	job = Runtime.getRuntime().exec(cmd);

	if(job.waitFor() != 0)
	    throw new ExecutionException("Job " + cmd + " failed");

	BufferedReader br = new BufferedReader(
			    new InputStreamReader(job.getInputStream()));
	br.readLine();
	String id = br.readLine();
	if(id == null || ! id.startsWith("0x"))
	    throw new ExecutionException("Invalid window address : " + id);
	    
	return id;
    }
    catch(InterruptedException ex) {
	throw new ExecutionException("For " + cmd + " " + ex.getMessage());
    }
    catch(IOException ex) {
	throw new ExecutionException("For " + cmd + " " + ex.getMessage());
    }
}
//______________________________________________________________________________
/**
 * Prints the list of windows known by Konqueror.
 * <br>
 * It runs the following commands :<br>
 * <code>dcop konqueror</code><br>
 * It can be useful for KDE 2.1
 * @see #getWindowId()
 */
final private void listWindowIds()
{
    try {
	/**
	 * Dunno exactly why it is necessary !
	 */
	String  cmd = "dcop konqueror default getWindows";
	Process job = Runtime.getRuntime().exec(cmd);

	if(job.waitFor() != 0) {
	    ToolBox.warn("Job " + cmd + " failed");
	    return;
	}

	cmd = "dcop konqueror";
	job = Runtime.getRuntime().exec(cmd);

	if(job.waitFor() != 0) {
	    ToolBox.warn("Job " + cmd + " failed");
	    return;
	}

	BufferedReader br = new BufferedReader(
			    new InputStreamReader(job.getInputStream()));

	System.out.println("List of Known windows :");

	String id = br.readLine();
	while(id != null) {
	    System.out.println(id);
	    id = br.readLine();
	}
    }
    catch(Exception ex) {
	ToolBox.warn("Can't get list of konqueror windows", ex);
    }
}
//______________________________________________________________________________
}
