//______________________________________________________________________________

//	The Java Virtual Shelf
//______________________________________________________________________________

package org.demo.webwader.gui;

import org.demo.webwader.rbi.RemoteDisplayer;
import org.demo.webwader.rbi.Browser;
import org.demo.webwader.Resources;
import org.ariane.exec.ExecutionException;
import org.ariane.tools.ToolBox;
import java.net.URL;
import java.rmi.registry.*;

/**
 * A displayer used to communicate with a Remote Java Browser.
 * <Br>
 * @version $Id: JavaDisplayer.java,v 1.4 2001/01/30 20:48:04 lefevre Exp $
 * @author Jean-Paul Le Fvre
 * @see NavePane
 * @see RemoteDisplayer
 */
//______________________________________________________________________________

abstract class JavaDisplayer extends AbstractDisplayer {
  /**
   * @serial The current remote displayer.
   */
protected RemoteDisplayer displayer = null;

//______________________________________________________________________________
/**
 * Returns the name of the current remote displayer.
 * <br>
 * The derived displayers have their own local <code>getName()</code> methods.
 * This one is provided for testing. Names retrieved either locally or
 * remotely should be the same.
 * In case of problem null is returned.
 * @return the string or null is case of problem.
 * @see RemoteDisplayer#getName
 */
final public String getRemoteName()
    {
	try {
	    return displayer.getName();
	}
	catch(Exception ex) {
	    if(ToolBox.debug) ToolBox.warn("Can't get name of displayer", ex);
	    return null;
	}
    }
//______________________________________________________________________________
/**
 * Gets a reference to the servant.
 * <br>
 * The current displayer is changed and activated.
 * @see LocateRegistry#getRegistry
 * @see Registry#lookup
 */
final private void getServant()
{
      try {
	  Resources rsrc = (org.demo.webwader.Resources)Resources.instance();
	  int port = rsrc.get(Browser.REGISTRY_PORT, Registry.REGISTRY_PORT);
	  Registry registry = LocateRegistry.getRegistry(port);

	  displayer = (RemoteDisplayer)registry.lookup(Browser.SERVANT);
      }
      catch(Exception ex) {
	ToolBox.warn("Can't create remote displayer", ex);
 	ErrorWindow.instance().display(
        "Can't create remote displayer !\n" +
        "Check if the server is running and try again.");
     }
}
//______________________________________________________________________________
/**
 * Activates this displayer.
 * <br>
 * The current displayer is changed and activated.
 * @see RemoteDisplayer#changeDisplayer
 */
final public void activate()
{
    try {
	boolean not_first_time = true;

	if(displayer == null) {
	    not_first_time = false;
	    getServant();
	}
	    
	if(displayer.changeDisplayer(getName())) {
	    displayer.activate();
	}
	else if(not_first_time) {
	    ErrorWindow.instance().display(
			"Can't install remote " + getName() + " !\n" +
			"Check if this displayer is available.");
	}
    }
    catch(Exception ex) {
	ToolBox.warn("Can't activate remote displayer", ex);
	ErrorWindow.instance().display(
	"Can't activate remote " + getName() + " !\n" +
	"Check if this displayer is available.");

	displayer = null;
	throw new ExecutionException("Remote displayer activation failed");
    }
}
//______________________________________________________________________________
/**
 * Displays the specified page in the browser.
 * <Br>
 * @param url the url of the page.
 * @return true is the page has been displayed.
 * @see #isToShow
 * @see RemoteDisplayer#displayPage
 */
final public boolean displayPage(URL url)
{
    try {
	if(! isToShow(url)) return false;

	displayer.displayPage(url);
    }
    catch(Exception ex) {
	ToolBox.warn("Can't display page with " + getName(), ex);
	ErrorWindow.instance().display(
	"Can't display page with " + getName() + " !\n" +
	"Check if the connection is still alive.");
	return false;
    }

    return true;
}
//______________________________________________________________________________
}








