//______________________________________________________________________________

//	The Java Virtual Shelf
//______________________________________________________________________________

package org.demo.webwader.gui;

import org.ariane.tools.ToolBox;
import org.ariane.tools.Resources;
import java.net.URL;
import java.io.File;

/**
 * A displayer used to communicate with IExplorer under Windows.
 * <Br>
 * It uses @{link Runtime.exec()} to run <Code>open_url</Code> which is
 * expected to be in $JVS_HOME\\bin.
 *
 * @version $Id: IExplorerWindows.java,v 3.2 2000/10/25 16:15:05 lefevre Exp $
 * @author Jean-Paul Le Fvre
 * @see NavePane
 */
//______________________________________________________________________________

class IExplorerWindows  extends BrowserWindows {
  /**
   * @serial The unique instance.
   */
private  static IExplorerWindows displayer = null;
    /**
     * @serial The name of this tool.
     */
protected static final String NAME = "IExplorer";

//______________________________________________________________________________
/**
 * Gets an unique instance of the displayer.
 * <Br>
 * It is a singleton
 * @return the unique instance.
 */
protected static IExplorerWindows instance()
  {
    if(displayer == null) displayer = new IExplorerWindows();

    return displayer;
  }
//______________________________________________________________________________
/**
 * Creates the displayer.
 * <Br>
 * The path to the command <Code>open_url.exe -i</Code> is built.
 */
private IExplorerWindows()
  {
      super();
  }
//______________________________________________________________________________
/**
 * Returns the name of this tool.
 * @return the string.
 */
final public String getName()
{
    return NAME;
}
//______________________________________________________________________________
/**
 * Returns the path to Internet Explorer.
 * <br>
 * It is searched in the property : "IExplorerWindows.Path".
 * @return the path.
 */
final public String getPath()
{
    return Resources.instance().get("IExplorerWindows.Path",
           "C:\\Program Files\\Internet Explorer\\Iexplore.exe");
}
//______________________________________________________________________________
/**
 * Returns the flag used to launch Internet Explorer.
 * @return the string.
 */
final protected String getOptions()
{
    return "-i";
}
//______________________________________________________________________________
}


