//______________________________________________________________________________

//	The Java Virtual Shelf
//______________________________________________________________________________

package org.demo.webwader.gui;

import java.net.*;
import org.ariane.tools.ToolBox;
import org.ariane.exec.ExecutionException;

/**
 * A displayer using the remote facility of IExplorer on Unix.
 * <Br>
 * It uses @{link Runtime.exec()} to run
 * <Code>iexplorer -remote url</Code>.
 * It has been tested on Solaris.
 *
 * @version $Id: IExplorerUnix.java,v 1.3 2001/01/13 18:27:25 lefevre Exp $
 * @author Jean-Paul Le Fvre
 * @see NavePane
 * @see BrowserWindows
 */
//______________________________________________________________________________

class IExplorerUnix extends AbstractDisplayer {
  /**
   * @serial The unique instance.
   */
private  static IExplorerUnix displayer = null;
  /**
   * @serial The name of the displayer.
   */
private  static final String IE5 = "iexplorer";
    /**
     * @serial The name of this tool.
     */
protected static final String NAME = "IExplorer";

//______________________________________________________________________________
/**
 * Gets an unique instance of the displayer.
 * <Br>
 * It is a singleton
 * @return the unique instance.
 */
protected static IExplorerUnix instance()
  {
    if(displayer == null) displayer = new IExplorerUnix();

    return displayer;
  }
//______________________________________________________________________________
/**
 * Activates IExplorer.
 * <br>
 * Checks to see if iexplorer is running. If not launches it.
 */
final public void activate()
{
    // /opt/JVS/lib/webwader-welcome.html
    String welcome = GuiResources.getWelcomeLocation();

    // iexplorer -remote /opt/JVS/lib/webwader-welcome.html
    StringBuffer buf = new StringBuffer(IE5).append(" -remote ");
    buf.append(welcome);

    String cmd  = buf.toString();

    try {
      	Process job = Runtime.getRuntime().exec(cmd);
	int     rc  = 1;
	try {
	    rc  = job.exitValue();
	}
	catch(IllegalThreadStateException ex) {
	    /**
	     * It's OK : it means that the subprocess, i.e. iexplorer,
	     * is running.
	     */
	    return;
	}
	if(rc == 0) return;

	ErrorWindow.instance().display("Can't launch IExplorer !");
	if(ToolBox.debug) ToolBox.warn(cmd + " rc : " + rc);
    }
    catch(Exception ex) {
	ToolBox.warn("Can't activate IExplorer", ex);
	ErrorWindow.instance().display(
	"Can't activate IExplorer !\nCheck if it is available on your system.");
	throw new ExecutionException("IExplorer activation failed");
    }
}
//______________________________________________________________________________
/**
 * Returns the name of this tool.
 * @return the string.
 */
final public String getName()
{
    return NAME;
}
//______________________________________________________________________________
/**
 * Displays the specified page.
 * <Br>
 * For this method to work, IExplorer must be already running.
 * @param url the url of the page.
 * @return true is the page has been displayed.
 * @see #isToShow
 * @see Runtime
 */
final public boolean displayPage(URL url)
{
    try {
	if(! isToShow(url)) return false;

	String cmd  = IE5 + " -remote " + url.toExternalForm();
	Process job = Runtime.getRuntime().exec(cmd);

	int rc = job.waitFor();
	if(rc != 0) {
	    ErrorWindow.instance().display(
	    "Can't run IExplorer !\nCheck if it is running.");
	    return false;
	}
    }
    catch(Exception ex) {
	ToolBox.warn("Can't display page thru IExplorer", ex);
	ex.printStackTrace();
	return false;
    }

    return true;
}
//______________________________________________________________________________
}


