//______________________________________________________________________________

//	The Java Virtual Shelf
//______________________________________________________________________________

package org.demo.webwader.gui;

import org.ariane.tools.ToolBox;
import org.demo.webwader.rbi.DisplayersBag;
/**
 * A displayer used to communicate with the remote browser HTMLWindow.
 * <br>
 * It should compile even if Horst is not available.
 * @version $Id: HorstDisplayer.java,v 1.2 2001/01/14 17:52:38 lefevre Exp $
 * @author Jean-Paul Le Fvre
 * @see NavePane
 */
//______________________________________________________________________________

class HorstDisplayer extends JavaDisplayer {
  /**
   * @serial The unique instance.
   */
private  static HorstDisplayer instance = null;
    /**
     * @serial The name of this tool.
     */
protected static final String NAME = DisplayersBag.HORST_DISPLAYER_NAME;

//______________________________________________________________________________
/**
 * Gets an unique instance of the displayer.
 * <Br>
 * It is a singleton
 * @return the unique instance.
 */
protected static HorstDisplayer instance()
  {
    if(instance == null) instance = new HorstDisplayer();

    return instance;
  }
//______________________________________________________________________________
/**
 * Creates the displayer.
 */
private HorstDisplayer()
  {
      super();
  }
//______________________________________________________________________________
/**
 * Returns the name of this tool.
 * @return the string.
 */
final public String getName()
{
    return NAME;
}
//______________________________________________________________________________
}


