//______________________________________________________________________________

//	The Java Virtual Shelf
//______________________________________________________________________________

package org.demo.webwader.gui;

import org.demo.webwader.Resources;

/**
 * A specific Resources object.
 * <Br>
 * It provides values for various parameters used to display the GUI.
 *
 * @version $Id: GuiResources.java,v 3.3 2001/01/07 13:15:52 lefevre Exp $
 * @author Jean-Paul Le Fvre
 */
//______________________________________________________________________________

public	class GuiResources extends org.ariane.gui.GuiResources {
  /**
   * @serial The unique instance.
   */
private static  GuiResources resources = null;

//______________________________________________________________________________
/**
 * Creates the Resources object.
 * <Br>
 * It is derived from the webwader resources.
 * The specific GUI resources for this application are initialized.
 */
private GuiResources()
  {
      super();
  }
//______________________________________________________________________________
/**
 * Gets an unique instance of Resources.
 * <Br>
 * It is a singleton
 * @return the unique instance.
 */
public static GuiResources instance()
  {
    if(resources == null)
	resources = new GuiResources();

    return resources;
  }
//______________________________________________________________________________
/**
 * Gets the prefix used to create attibute names.
 * <Br>
 * @return the prefix.
 */
public String getAppplicationPrefix()
  {
    return org.demo.webwader.Resources.PREFIX;
  }
//______________________________________________________________________________
/**
 * Gets the local URL of the welcome-page.
 * <br>
 * In case of errors return file:/opt/JVS/lib/webwader-welcome.html.
 * @return the location.
 */
public static String getWelcomeLocation()
  {
      return Resources.getWelcomeLocation();
  }
//______________________________________________________________________________
}
