//______________________________________________________________________________

//	The Java Virtual Shelf
//______________________________________________________________________________

package org.demo.webwader.gui;

import java.net.*;
import org.ariane.tools.ToolBox;
import org.demo.webwader.Resources;
import org.ariane.exec.ExecutionException;

/**
 * A displayer launching Galeon.
 * <Br>
 * It uses @{link Runtime.exec()} to run <Code>galeon -x url</Code>.
 *
 * @version $Id: Galeon.java,v 3.1 2001/01/03 20:27:56 lefevre Exp $
 * @author Jean-Paul Le Fvre
 * @see NavePane
 */
//______________________________________________________________________________

class Galeon extends AbstractDisplayer {
  /**
   * @serial The unique instance.
   */
private  static Galeon displayer = null;
    /**
     * @serial The name of this tool.
     */
protected static final String NAME = "Galeon";

//______________________________________________________________________________
/**
 * Gets an unique instance of the displayer.
 * <Br>
 * It is a singleton
 * @return the unique instance.
 */
protected static Galeon instance()
  {
    if(displayer == null) displayer = new Galeon();

    return displayer;
  }
//______________________________________________________________________________
/**
 * Activates Galeon.
 */
final public void activate()
{
    // /opt/JVS/lib/webwader-welcome.html. Galeon does not accept 'file:'
    String welcome  = Resources.instance().getLibDirectory() +
                      "webwader-welcome.html";

    // galeon -x /opt/JVS/lib/webwader-welcome.html
    StringBuffer buf = new StringBuffer("galeon ").append(welcome);
    String cmd  = buf.toString();

    try {
	Process job = Runtime.getRuntime().exec(cmd);
	int rc = 0;
	try {
	    rc  = job.exitValue();
	}
	catch(IllegalThreadStateException ex) {
	     // It's OK : it means that the browser is running.
	    return;
	}

	ErrorWindow.instance().display("Can't launch Galeon !");
	if(ToolBox.debug) ToolBox.warn(cmd + " rc : " + rc);
    }
    catch(Exception ex) {
	ToolBox.warn("Can't activate Galeon", ex);
	if(ToolBox.debug) ex.printStackTrace();
	throw new ExecutionException("Galeon activation failed");
    }
}
//______________________________________________________________________________
/**
 * Returns the name of this tool.
 * @return the string.
 */
final public String getName()
{
    return NAME;
}
//______________________________________________________________________________
/**
 * Displays the specified page.
 * <Br>
 * @param url the url of the page.
 * @return true is the page has been displayed.
 * @see #isToShow
 * @see Runtime
 */
final public boolean displayPage(URL url)
{
    try {
	if(! isToShow(url)) return false;

	String cmd  = "galeon -x " + url.toExternalForm();
	Process job = Runtime.getRuntime().exec(cmd);

	int rc = job.waitFor();
	if(rc != 0) {
	    ErrorWindow.instance().display(
	    "Can't run Galeon !\nCheck if it is running.");
	    return false;
	}
    }
    catch(Exception ex) {
	ToolBox.warn("Can't display page with Galeon", ex);
	ex.printStackTrace();
	return false;
    }

    return true;
}
//______________________________________________________________________________
}


