//______________________________________________________________________________

//	The Java Virtual Shelf
//______________________________________________________________________________

package org.demo.webwader.gui;

import javax.swing.*;
import java.awt.Component;
import java.io.File;
import javax.swing.filechooser.FileFilter;

import org.ariane.tools.ToolBox;

/**
 * A customized Dialog used to display a file chooser.
 * <Br>
 *
 * @version $Id: FileChooser.java,v 3.1 2000/10/25 16:15:05 lefevre Exp $
 * @author Jean-Paul Le Fvre
 */
//______________________________________________________________________________

public class FileChooser extends JFileChooser {
  /**
   * @serial The unique instance.
   */
private  static FileChooser window = null;
  /**
   * @serial The default file filter.
   */
private  FileFilter filter;

//______________________________________________________________________________
/**
 * Gets an unique instance of the window.
 * <Br>
 * It is a singleton
 * @return the unique instance.
 */
protected static FileChooser instance()
  {
      if(window == null) window = new FileChooser();

      return window;
  }
//______________________________________________________________________________
/**
 * Creates the FileChooser.
 */
private FileChooser()
  {
      super();

      GuiResources resources = GuiResources.instance();

      setBackground(resources.getMainBackground());
      setForeground(resources.getMainForeground());
      setCurrentDirectory(new File(resources.get("Datapath", ".")));
      setFileSelectionMode(FILES_ONLY);
      filter = getFileFilter();

  }
//______________________________________________________________________________
/**
 * Changes or resets the file filter.
 * <Br>
 * @param ff the filter to use or null to reset to default.
 */
public void setFileFilter(FileFilter ff)
{
    if(ff == null) ff = filter;
    super.setFileFilter(ff);
}
//______________________________________________________________________________
/**
 * Displays the file chooser.
 * <Br>
 * @return the code of the button pressed.
 * @see #showDialog
 */
public int display(String approve)
{
    int rc = showDialog(MainFrame.instance(), approve);
    return rc;
}
//______________________________________________________________________________
}


