//______________________________________________________________________________

//	The Java Virtual Shelf
//______________________________________________________________________________

package org.demo.webwader.gui;

import org.ariane.tools.ToolBox;
import org.demo.webwader.Resources;
import java.net.URL;
import java.io.File;
import java.io.IOException;
import org.ariane.exec.ExecutionException;

/**
 * A displayer used to communicate with Emacs.
 * <Br>
 * It uses @{link Runtime.exec()} to run <Code>gnudoit</Code>.
 * For more information see the man page <Code>gnuserv(1)</Code>.
 * <p>
 * 
 *
 * @version $Id: EmacsW3.java,v 1.5 2001/01/07 13:17:04 lefevre Exp $
 * @author Jean-Paul Le Fvre
 * @see NavePane
 */
//______________________________________________________________________________

class EmacsW3 extends AbstractDisplayer {
  /**
   * @serial The path to the command + a white space.
   */
private String command = null;
  /**
   * @serial The unique instance.
   */
private  static EmacsW3 displayer = null;
    /**
     * @serial The name of this tool.
     */
protected static final String NAME = "Emacs";
    /**
     * @serial The quote used for passing parameter to emacs.
     * I know it's horrible :(
     */
private static String EQ = ToolBox.isUnderWindows() ? "\\\"" : "\"";

//______________________________________________________________________________
/**
 * Gets an unique instance of the displayer.
 * <Br>
 * It is a singleton
 * @return the unique instance.
 */
protected static EmacsW3 instance()
  {
    if(displayer == null) displayer = new EmacsW3();

    return displayer;
  }
//______________________________________________________________________________
/**
 * Creates the displayer.
 * <Br>
 * The path to the command <Code>gnudoit</Code> is built, the
 * option is appended.
 * @see #getOptions()
 */
protected EmacsW3()
  {
      command = getPath();

      File file = new File(command);
      if(! file.exists()) {
	  ToolBox.warn("Can't find " + command);
	  command = null;
	  return;
      }

      command += ' ' + getOptions() + ' ';
  }
//______________________________________________________________________________
/**
 * Returns the command launching the client.
 * <br>
 * It is <code>gnudoit -q (w3-fetch "url")</code>
 * <br>
 * The quoting is different under Unix and under Windows.
 * @return the string.
 */
final private String getCommand(String url)
    {
	StringBuffer buf = new StringBuffer(command);
	// EQ (escaped quote) depends on OS. Dunno why.
	buf.append("(w3-fetch ").append(EQ).append(url).append(EQ).append(')');
	return buf.toString();
    }
//______________________________________________________________________________
/**
 * Activates this displayer.
 * <br>
 * It displays the WebWader welcome page.
 * @see #getCommand(String)
 */
final public void activate()
{
    String cmd = "";
    try {
	cmd = getCommand(GuiResources.getWelcomeLocation());
	Process job = Runtime.getRuntime().exec(cmd);
	int rc = 0;
	try {
	    rc  = job.exitValue();
	}
	catch(IllegalThreadStateException ex) {
	     // It's OK : it means that the browser is running.
	    return;
	}

	ErrorWindow.instance().display("Can't launch " + cmd + " !");
	if(ToolBox.debug) ToolBox.warn(cmd + " rc : " + rc);
    }
    catch(IOException ex) {
	ErrorWindow.instance().display("Can't run " + getName() +
				   " !\nCheck " + getPath());
	if(ToolBox.debug) ToolBox.warn("Can't run " + cmd, ex);
	throw new ExecutionException("Emacs activation failed");
    }
    catch(Exception ex) {
	ToolBox.warn("Can't activate " + getName(), ex);
	if(ToolBox.debug) ex.printStackTrace();
	throw new ExecutionException("Emacs activation failed");
    }
}
//______________________________________________________________________________
/**
 * Displays the specified page in Emacs.
 * <Br>
 * @param url the url of the page.
 * @return true is the page has been displayed.
 * @see #isToShow
 * @see Runtime
 */
final public boolean displayPage(URL url)
{
    try {
	if(! isToShow(url)) return false;

	String cmd  = getCommand(url.toExternalForm());
	Process job = Runtime.getRuntime().exec(cmd);
			      
	int rc = job.waitFor();
	if(rc != 0) {
	    if(ToolBox.debug) ToolBox.warn(cmd + " rc : " + rc);
	    ErrorWindow.instance().display("Can't run " + getName() +
			                   " !\nCheck if it is running.");
	}
    }
    catch(Exception ex) {
	ToolBox.warn("Can't display page with " + command, ex);
	if(ToolBox.debug) ex.printStackTrace();
	return false;
    }

    return true;
}
//______________________________________________________________________________
/**
 * Returns the name of this tool.
 * @return the string.
 */
final public String getName()
{
    return NAME;
}
//______________________________________________________________________________
/**
 * Returns the path to gnudoit.
 * <br>
 * It is searched in the property : "EmacsW3.Path"
 * @return the path.
 */
final public String getPath()
{
    return Resources.instance().get("EmacsW3.Path", "/usr/local/bin/gnudoit");
}
//______________________________________________________________________________
/**
 * Returns the flag used to launch gnudoit.
 * @return the string.
 */
final protected String getOptions()
{
    return "-q";
}
//______________________________________________________________________________
}


