//______________________________________________________________________________

//	Java Virtual Shelf	- Jean-Paul Le Fevre
//______________________________________________________________________________

package org.demo.webwader.gui;
import java.net.URL;

/**
 * A displayer knows how to display a document.
 * @author   Jean-Paul Le Fvre
 * @version $Id: Displayer.java,v 3.3 2001/01/07 13:15:07 lefevre Exp $
 */

public interface Displayer {
  /*
   * Activates this tool.
   * <br>
   * Used on Win32 to start the browser and/or make it current.
   */
void activate();
  /*
   * Displays a HTML page.
   * <br>
   * It the url points to a document which is not displayable, the method
   * returns false. The Traverser can then suppress the pause.
   *
   * @param url the locator of the document to show.
   * @return true if the page has been actually shown, false otherwise.
   */
boolean displayPage(URL url);
  /*
   * Gets the name of the displayer.
   * @return a ident.
   */
String getName();

//______________________________________________________________________________
}









