//______________________________________________________________________________

//	The Java Virtual Shelf
//______________________________________________________________________________

package org.demo.webwader.gui;

/**
 * A customized Dialog.
 * @version $Id: Dialog.java,v 3.2 2001/01/07 13:18:39 lefevre Exp $
 * @author Jean-Paul Le Fvre
 */
//______________________________________________________________________________

abstract class Dialog extends org.ariane.gui.Dialog {

//______________________________________________________________________________
/**
 * Creates a Dialog without title.
 */
protected Dialog()
  {
      this(null);
  }
//______________________________________________________________________________
/**
 * Creates a Dialog with a title and without a icon.
 * @param title the header of the dialog.
 */
protected Dialog(String title)
  {
      this(title, null);
  }
//______________________________________________________________________________
 /**
  * Creates a Dialog with a title.
  * @param title the header of the dialog. Can be null.
  * @param icon_file the file name of the image. Can be null.
  */
protected Dialog(String title, String icon_file)
  {
      super(MainFrame.instance(), title, icon_file);
  }
//______________________________________________________________________________
 /**
  * Creates a Dialog with a title.
  * @param title the header of the dialog. Can be null.
  * @param icon_file the file name of the image. Can be null.
  * @param modal true for a modal dialog, false otherwise.
  */
protected Dialog(String title, String icon_file, boolean modal)
  {
      super(MainFrame.instance(), title, icon_file, modal);
  }
//______________________________________________________________________________
/**
 * Installs the resources used to build the Dialog.
 */
protected void setResources()
    {
	resources = GuiResources.instance();
    }
//______________________________________________________________________________
}



