//______________________________________________________________________________

//	The Java Virtual Shelf
//______________________________________________________________________________

package org.demo.webwader.gui;

import org.ariane.tools.ToolBox;
import org.demo.webwader.Resources;
import org.ariane.exec.ExecutionException;
import java.net.URL;
import java.io.File;
import java.io.IOException;

/**
 * A displayer used to communicate with a Browser under Windows.
 * <Br>
 * It uses @{link Runtime.exec()} to run <Code>open_url</Code> which is
 * expected to be in $JVS_HOME/bin.
 *
 * @version $Id: BrowserWindows.java,v 3.7 2000/11/18 16:12:50 lefevre Exp $
 * @author Jean-Paul Le Fvre
 * @see NavePane
 */
//______________________________________________________________________________

abstract class BrowserWindows extends AbstractDisplayer {
  /**
   * @serial The path to the command + a white space.
   */
private String command = null;

//______________________________________________________________________________
/**
 * Creates the displayer.
 * <Br>
 * The path to the command <Code>open_url.exe</Code> is built, the
 * arguments are appended.
 * @see #getOptions()
 */
protected BrowserWindows()
  {
      String jvs_bin  = Resources.instance().getBinDirectory();
      command         = jvs_bin + "open_url.exe";

      File file       = new File(command);
      if(! file.exists()) {
	  ToolBox.warn("Can't find " + command);
	  command = null;
	  return;
      }

      command += ' ' + getOptions() + ' ';
  }
//______________________________________________________________________________
/**
 * Returns the full path to this tool.
 * <Br>
 * This depends on its location on the file system.
 * @return the string.
 */
abstract public String getPath();
//______________________________________________________________________________
/**
 * Returns the name of this tool.
 * <Br>
 * This depends on the actual browser used.
 * @return the string.
 */
abstract public String getName();
//______________________________________________________________________________
/**
 * Returns the list of flags passed to the command.
 * <Br>
 * This depends on the actual browser used.
 * @return the string.
 */
abstract protected String getOptions();
//______________________________________________________________________________
/**
 * Returns the command launching the tool.
 * @return the string.
 */
final private String getCommand()
    {
	return command;
    }
//______________________________________________________________________________
/**
 * Activates this displayer.
 * <br>
 * It calls the command 'activate' based on the DDE 'WWW_Activate' request.
 * If the command fails the browser is launched. The path to the browser
 * may be defined in the properties.
 * @see #getPath()
 */
final public void activate()
{
    StringBuffer buf = new StringBuffer(Resources.instance().getBinDirectory());
    buf.append("activate.exe ").append(getName());

    String cmd = "";
    try {
	/**
	 * Try to activate the browser. If the action is successful
	 * return. Otherwise launch the program.
	 */
	Process job = Runtime.getRuntime().exec(buf.toString());
	int rc = job.waitFor();
	if(rc == 0) return;

	// c:\Program Files\Company\browser.exe \JVS\lib\webwader-welcome.html
	Resources rsrc = (org.demo.webwader.Resources)Resources.instance();
	buf = new StringBuffer(getPath());
	buf.append(' ').append(rsrc.getWelcomeLocation());
	cmd = buf.toString();

	job = Runtime.getRuntime().exec(cmd);
	try {
	    rc  = job.exitValue();
	}
	catch(IllegalThreadStateException ex) {
	     // It's OK : it means that the browser is running.
	    return;
	}
	ErrorWindow.instance().display("Can't launch " + cmd + " !");
	if(ToolBox.debug) ToolBox.warn(buf.toString() + " rc : " + rc);
    }
    catch(IOException ex) {
	ErrorWindow.instance().display("Can't run " + getName() +
				   " !\nCheck " + getPath());
	if(ToolBox.debug) ToolBox.warn("Can't run " + cmd, ex);
	throw new ExecutionException("Browser activation failed");
    }
    catch(Exception ex) {
	ToolBox.warn("Can't activate " + getName(), ex);
	if(ToolBox.debug) ex.printStackTrace();
	throw new ExecutionException("Browser activation failed");
    }
}
//______________________________________________________________________________
/**
 * Displays the specified page in the browser.
 * <Br>
 * @param url the url of the page.
 * @return true is the page has been displayed.
 * @see #isToShow
 * @see Runtime
 */
final public boolean displayPage(URL url)
{
    try {
	if(! isToShow(url)) return false;

	Process job = Runtime.getRuntime().exec(
			      getCommand() + url.toExternalForm());
	int rc = job.waitFor();
	if(rc != 0) {
	    if(ToolBox.debug) ToolBox.warn(getCommand() + " rc : " + rc);
	    ErrorWindow.instance().display("Can't run " + getName() +
			                   " !\nCheck if it is running.");
	}
    }
    catch(Exception ex) {
	ToolBox.warn("Can't display page with " + getCommand(), ex);
	if(ToolBox.debug) ex.printStackTrace();
	return false;
    }

    return true;
}
//______________________________________________________________________________
}


