//______________________________________________________________________________

//	The Java Virtual Shelf
//______________________________________________________________________________

package org.demo.webwader.gui;

import java.net.*;
import org.ariane.tools.ToolBox;
import org.ariane.exec.ExecutionException;

/**
 * A displayer using the remote facility of Mozilla or Opera on Unix.
 * <br>
 * Netscape, Mozilla and Opera accept the same command line argument :
 * <code>-remote openUrl()</code>
 * @version $Id: AbstractMozillaUnix.java,v 1.4 2001/02/14 20:56:30 lefevre Exp $
 * @author Jean-Paul Le Fvre
 * @see NavePane
 * @see BrowserWindows
 */
//______________________________________________________________________________

abstract class AbstractMozillaUnix extends AbstractDisplayer {

//______________________________________________________________________________
/**
 * Returns the command launching the tool with a white space appended.
 * @return the string.
 */
abstract protected String getCommand();

//______________________________________________________________________________
/**
 * Activates the browser.
 * <br>
 * Checks to see if the browser is running. If not launches it.
 * Opera has its own method.
 */
public void activate()
{
    // /opt/JVS/lib/webwader-welcome.html
    String welcome = GuiResources.getWelcomeLocation();

    // mozilla -remote openURL(/opt/JVS/lib/webwader-welcome.html)
    StringBuffer buf =
    new StringBuffer(getCommand()).append("-remote openURL(");
    buf.append(welcome).append(")");

    String cmd  = buf.toString();

    try {
	/**
	 * First, try to use the -remote option. If the browser is
	 * running, it should display the welcome page; if not,
	 * the command should fail.
	 */
	Process job = Runtime.getRuntime().exec(cmd);
	int rc      = job.waitFor();

	if(rc == 0) return;

	/**
	 * Run : mozilla /opt/JVS/lib/webwader-welcome.html
	 */
	if(ToolBox.verbose) ToolBox.warn("Launching the browser ...");
	buf = new StringBuffer(getCommand()).append(welcome);
	cmd = buf.toString();

	job = Runtime.getRuntime().exec(cmd);
	try {
	    rc  = job.exitValue();
	}
	catch(IllegalThreadStateException ex) {
	    /**
	     * It's OK : it means that the subprocess, i.e. mozilla,
	     * is running.
	     */
	    Thread.sleep(3000); // Give the browser some time to get ready.
	    return;
	}
	ErrorWindow.instance().display("Can't launch the browser !");
	if(ToolBox.debug) ToolBox.warn(cmd + " rc : " + rc);
    }
    catch(Exception ex) {
	ToolBox.warn("Can't activate the browser", ex);
	if(ToolBox.debug) ex.printStackTrace();
	throw new ExecutionException("Browser activation failed");
    }
}
//______________________________________________________________________________
/**
 * Displays the specified page.
 * <Br>
 * For this method to work, the browser must be already running.
 * @param url the url of the page.
 * @return true is the page has been displayed.
 * @see #isToShow
 * @see java.lang.Runtime
 */
final public boolean displayPage(URL url)
{
    try {
	if(! isToShow(url)) return false;

	String cmd  = getCommand() + "-remote openURL(" 
	                           + url.toExternalForm() +")";
	Process job = Runtime.getRuntime().exec(cmd);

	int rc = job.waitFor();
	if(rc != 0) {
	    ErrorWindow.instance().display(
	    "Can't run the browser !\nCheck if it is running.");
	    return false;
	}
    }
    catch(Exception ex) {
	ToolBox.warn("Can't display page thru the browser", ex);
	ex.printStackTrace();
	return false;
    }

    return true;
}
//______________________________________________________________________________
}


