//______________________________________________________________________________

//	The Java Virtual Shelf
//______________________________________________________________________________

package org.demo.webwader.gui;

/**
 * The list of available displayers.
 * <br>
 * It manages the collection and the current displayer.
 *
 * @version $Id: AbstractDisplayersBag.java,v 3.2 2001/01/20 09:32:15 lefevre Exp $
 * @author Jean-Paul Le Fvre
 */
//______________________________________________________________________________

public abstract class AbstractDisplayersBag {
  /**
   * @serial The current displayer.
   */
protected Displayer displayer = null;
    /**
     * @serial The array of available displayers.
     */
protected String[] DISPLAYERS;

//______________________________________________________________________________
/**
 * Gets the list of names of the available displayers.
 * <Br>
 * @return the array.
 */
final public String[] getNamesList()
{
    return DISPLAYERS;
}
//______________________________________________________________________________
/**
 * Gets the index of the specified displayer.
 * <br>
 * The implementation is case insensitive.
 * @param name the name of the tool.
 * @return the index of the current tool.
 * @throw NoSuchDisplayerException if the name is not found.
 */
final public int getDisplayerIndex(String name)
                                                 throws NoSuchDisplayerException
{
    if(name == null) 
	throw new NoSuchDisplayerException("Invalid null displayer");

    for(int i = 0; i < DISPLAYERS.length; i++) {
	if(name.equalsIgnoreCase(DISPLAYERS[i])) {
	    return i;
	}
    }

    throw new NoSuchDisplayerException("No displayer " + name + " found");
}
//______________________________________________________________________________
/**
 * Gets the current displayer.
 *
 * @return the displayer.
 * @see #getDisplayerName
 * @see #getDisplayerIndex
 */
final public Displayer getDisplayer()
{
    return displayer;
}
//______________________________________________________________________________
/**
 * Gets the name of the current displayer.
 * <Br>
 * @return the name or null.
 * @see #getDisplayer
 */
final protected String getDisplayerName()
{
    return displayer == null ? null : displayer.getName();
}
//______________________________________________________________________________
/**
 * Gets the index of the current displayer.
 * <Br>
 * @return the index of the current tool or -1.
 * @see #getDisplayer
 */
final public int getDisplayerIndex()
{
    if(displayer == null) return -1;

    return getDisplayerIndex(displayer.getName());
}
//______________________________________________________________________________
/**
 * Sets the current tool used to display pages.
 * <Br>
 * Existence of the new displayer is not checked.
 * @param tool the name of the new displayer.
 * @see #setDisplayer(int)
 * @throw NoSuchDisplayerException if the tool is unknown.
 */
final protected boolean setDisplayer(String tool)
                                                 throws NoSuchDisplayerException
{
    return setDisplayer(getDisplayerIndex(tool));
}
//______________________________________________________________________________
/**
 * Sets the current tool used to display pages.
 *
 * @param index the index of the new displayer.
 * @return true if the displayer is actually changed.
 */
abstract protected boolean setDisplayer(int index);

//______________________________________________________________________________
}








