/*____________________________________________________________________________*/
/**
 * Send_url is used to test communication between an X11 application
 * and a client.
 *
 * Usage : send_url [-d] [-p port] string
 * Flag -d : debug mode, default port if not specified 8333.
 *
 * Jean-Paul Le Fvre - November 2000
 * $Id: send_url.c,v 1.1 2000/11/30 20:53:33 lefevre Exp $
/*____________________________________________________________________________*/

# include <stdio.h> 
# include <stdlib.h> 
# include <string.h>
# include <sys/types.h> 
# include <sys/socket.h> 
# include <netinet/in.h> 
# include <netdb.h> 

static int debug = 0;

int main(int argc, char *argv[])
{ 
  struct sockaddr_in saddr ;
  struct hostent* host; 
  const char*     url;
  int		  port = 8333;
  int	          c;
  int	          s;
  extern char*    optarg;
  extern int      optind;

  while((c = getopt(argc, argv, "dp:")) != -1) {
    switch(c) {
    case 'd' :
      debug = 1;
      break;

    case 'p' :
      port = atoi(optarg);
      break;
    }
  }

  if(optind >= argc) { 
      fprintf(stderr, "Usage: %s [-d][-p port] string\n", argv[0]); 
      exit(1) ;
  } 
  else if(port < 1024 || port > 65534) {
    fprintf(stderr, "Invalid port number : %d\n", port);
    exit(1);
  }

  url  = argv[optind];

  if((host = gethostbyname("localhost")) == NULL) {
    perror("Can't get hostname");
    exit(1);
  }

  memset(&saddr, 0 , sizeof(saddr));
  memcpy(&saddr.sin_addr, host->h_addr, host->h_length) ; 
  saddr.sin_port   = htons(port);
  saddr.sin_family = AF_INET;

  if((s = socket(AF_INET, SOCK_STREAM, 0)) < 0) {
    perror("Can't create socket");
    exit(1);
  }
  if(debug) printf("Socket created !\n");

  if(connect (s, &saddr, sizeof(saddr)) < 0) {
    perror("Can't connect socket");
    exit(1);
  }
  if(debug) printf("Socket connected !\n");

  c = strlen(url) + 1;
  if(write(s, url, c) != c) {
    perror("Can't write to socket");
    close(s);
    exit(1);
  } 
  if(debug) printf("String %s written !\n", url);
  close(s);

  return 0;
}
/*____________________________________________________________________________*/
