/*____________________________________________________________________________*/
/*
  Content : Program used to display an URL with a browser under Windows.
            See org.demo.webwader.gui.BrowserWindows.java
            Implemented : Netscape, IExplorer, Opera, Mozilla.

  Usage   : open_url [-V] -n|-i|-o|-m --name browser url
  Return  : 0 for success, 1 for failure.
  Author  : Jean-Paul Le Fvre - August 2000
  CVS     : $Id: open_url.c,v 3.2 2001/06/12 14:04:02 lefevre Exp $
*/
/*____________________________________________________________________________*/

#include <windows.h>
#include <ddeml.h>
#include <stdlib.h>
#include <stdio.h>

HDDEDATA CALLBACK DdeCallback (UINT uType, UINT uFmt, HCONV hconv,
	     HSZ hsz1, HSZ hsz2, HDDEDATA hdata,
	     DWORD dwData1, DWORD dwData2)
{
  return ((HDDEDATA) NULL);
}
/*____________________________________________________________________________*/

int main (int argc, char *argv[])
{
  DWORD idDde = 0;
  HCONV HConversation;
  HSZ   Item;
  HSZ   Server;
  HSZ   Topic;
  char  params[1024]; /* Hope it's enough ! */
  const char* browser;
  const char* url;
  HDDEDATA rc;
  int   verbose = 0;
  int   i = 2; /* index of the url argument */

  if (argc > 1 && strcmp(argv[1], "-V") == 0) {
    printf ("$Id: open_url.c,v 3.2 2001/06/12 14:04:02 lefevre Exp $\n");
    exit (1);
  }
  else if (argc < 3) {
    fprintf (stderr, "Usage : open_url -V|-n|-i|-o|--name browser url\n");
    exit (1);
  }
  else if(strcmp(argv[1], "-n") == 0) {
    browser = "NETSCAPE";
  }
  else if(strcmp(argv[1], "-i") == 0) {
    browser = "IEXPLORE";
  }
  else if(strcmp(argv[1], "-o") == 0) {
    browser = "OPERA";
  }
  else if(strcmp(argv[1], "-m") == 0) {
    browser = "MOZILLA";
  }
  else if(strcmp(argv[1], "--name") == 0) {
    if (argc < 4) {
      fprintf (stderr, "Usage : open_url -V|-n|-i|-o|-m |--name browser url\n");
      exit (1);
    }
    browser = argv[2];
    i = 3;
  }

  url = argv[i];
  sprintf(params, "%c%s%c,,0xFFFFFFFF,0x0", '"', url, '"');

  DdeInitialize (&idDde, (PFNCALLBACK)DdeCallback, APPCMD_CLIENTONLY, 0);

  Server = DdeCreateStringHandle (idDde, browser, CP_WINANSI);
  Topic  = DdeCreateStringHandle (idDde, "WWW_OpenURL", CP_WINANSI);
  Item   = DdeCreateStringHandle (idDde, params, CP_WINANSI);

  HConversation = DdeConnect (idDde, Server, Topic, NULL);
  rc            = DdeClientTransaction (NULL, 0ul, HConversation, Item,
		  CF_TEXT, XTYP_REQUEST, 30000, NULL);

  DdeDisconnect (HConversation);
  if(verbose) printf("Returned : %d for %s %s\n", rc, browser, url);

  DdeFreeStringHandle (idDde, Server);
  DdeFreeStringHandle (idDde, Topic);
  DdeFreeStringHandle (idDde, Item);
  DdeUninitialize (idDde);

  return rc == NULL ? 1 : 0;
}
/*____________________________________________________________________________*/

