
/*____________________________________________________________________________*/
/**
 * Here is a piece of code which has to be included in EDITORAPP.c
 * in the code of Amaya. A good place for this inclusion is just
 * before the body of EDITORApplicationInitialise().
 *
 * Another statement has to be added in EDITORAPP.c : it is
 * W4addListener(port, W4updateURL) just before calling TtaMainLoop()
 *
 * WorldWideWebWader's modification begin.
 * $Id: amaya_server.c,v 1.1 2000/11/30 20:53:33 lefevre Exp $
 */
/* A couple of extern variables :( are necessary */
#define  THOT_EXPORT extern
#include "amaya.h"
/* The listener provides the server facility */
static XtInputId W4addListener(int, XtInputCallbackProc);
/* The method which is called when a url arrives from the network */
static void      W4updateURL(XtPointer, int*, XtInputId*);

static int	 port  = 8333; /* The server port is hardcoded */
static int 	 debug = 0;
/*____________________________________________________________________________*/
/**
 * Adds an input source to the main event loop.
 * <br>
 * @param port the port the application is listening.
 * @param proc the callback which is called when something arrives.
 * @return the id of the new input or -1 in case of error.
 * @see XtAppAddInput
 */
static XtInputId W4addListener(int port, XtInputCallbackProc proc)
{
  XtInputId id;
  int s;
  int l;
  struct sockaddr_in saddr;
  struct hostent*    host;
  XtAppContext	     context;

  printf("Amaya is listening on port %d\n", port);
  s = socket(AF_INET, SOCK_STREAM, 0);
  if(s < 0) {
    perror("Can't create socket");
    return -1;
  }
  if(debug) printf("Socket created !\n");

  host = gethostbyname("localhost");

  saddr.sin_family = AF_INET;
  saddr.sin_port   = htons(port);
  memcpy(&saddr.sin_addr, host->h_addr, host->h_length);

  if(bind(s, &saddr, sizeof(saddr)) < 0) {
    perror("Can't bind socket");
    return -1;
  }

  if(debug) printf("Socket bound !\n");

  l = sizeof(saddr) ;
  if (getsockname(s, &saddr, &l) != 0) {
    perror("Can't get socket name");
    return -1;
  }
  if(debug) printf("Socket name got !\n");

  if(listen(s, 1) < 0) {
    perror("Can't listen to socket");
    return -1;
  }

  if(debug) printf("Socket ready !\n");

  context = XtDisplayToApplicationContext(TtaGetCurrentDisplay());

  id = XtAppAddInput(context, s, (XtPointer)XtInputReadMask, proc, NULL);

  if(debug) printf("Input added !\n");

  return id;
}
/*____________________________________________________________________________*/
/**
 * Updates the URL field when a new string is found from the connection.
 * @param field the TextField widget to update.
 * @param s the socket providing the data.
 * @param id the input id.
 */
static void W4updateURL(XtPointer field, int* s, XtInputId* id)
{
  int sfd;
  int n;
  char buffer[1024];
  Arg  args[1];

  if(debug) printf("Procedure called back\n");

  if((sfd = accept(*s, NULL, NULL)) < 0) {
     perror("Can't accept connection");
     return;
  }

  if(debug) printf("Connection accepted !\n");

  n = read(sfd, buffer, sizeof(buffer));
  if(n < 1) {
    perror("Can't read data");
    return;
  }

  buffer[n] = '\0'; 
  if(debug) printf("Got : %s (%d)\n", buffer, n);

  /* The following code comes from amaya/init.c */
  InNewWindow     = FALSE;
  CurrentDocument = 1;
  ustrcpy (LastURLName, buffer);
  CallbackDialogue (BaseDialog + OpenForm, INTEGER_DATA, (CHAR_T*) 1);

  close(sfd);
}
/**
 * WebWader's modification end.
 */
/*____________________________________________________________________________*/
