#! /bin/sh
#_______________________________________________________________________________
#
# Bourne shell script : amaya_patch.sh
# ID : $Id: amaya_patch.sh,v 1.1 2000/12/03 11:03:19 lefevre Exp $
#
# Jean-Paul Le Fvre - December 2000
# Usage : amaya_patch.sh in amaya subdirectory.

# This script installs automatically the modification in the Amaya source
# code to make possible the cooperation with WebWader.
# It must be run in Amaya/working_dir/amaya directory where EDITORAPP.c is.
# The code to add is found in JVS/src/org/demo/webwader/etc. It is in
# the file amaya_server.c which must be copied in Amaya/working_dir/amaya.
#
# Actually this script just inserts 2 lines of code with sed(1) :
# include "amaya_server.c" and
# W4addListener(port, W4updateURL);
#
#_______________________________________________________________________________

src=EDITORAPP.c
if [ ! -f ./$src ]; then
    echo "File $src not found in current directory ! "
    exit 1
fi

if [ ! -f ./amaya_server.c ]; then
    echo "File amaya_server.c not found in current directory ! "
    exit 1
fi
# Make a backup copy : EDITORAPP.c~
if [ ! -f ./$src~ ]; then
    cp $src $src~
fi

# Create the file storing commands for sed(1)
modif=modif.w4

cat >$modif <<EOF
/#include "message.h"/a\\
#include "amaya_server.c"
/TtaMainLoop ();/i\\
  W4addListener(port, W4updateURL);
EOF

sed -f $modif $src > $src.w4
mv $src.w4 $src
rm $modif

echo "File $src changed !"
#_______________________________________________________________________________


