/*____________________________________________________________________________*/
/*
  Content : Program used to activate a browser under Windows.
            See org.demo.webwader.gui.BorwserWindows.java
  Usage   : activate [-V] program
  Return  : 0 for success, 1 for failure.
  Author  : Jean-Paul Le Fvre - August 2000
  CVS     : $Id: activate.c,v 3.1 2000/10/25 16:17:01 lefevre Exp $
*/
/*____________________________________________________________________________*/

#include <windows.h>
#include <ddeml.h>
#include <stdlib.h>
#include <stdio.h>

HDDEDATA CALLBACK DdeCallback (UINT uType, UINT uFmt, HCONV hconv,
	     HSZ hsz1, HSZ hsz2, HDDEDATA hdata,
	     DWORD dwData1, DWORD dwData2)
{
  return ((HDDEDATA) NULL);
}
/*____________________________________________________________________________*/

int main (int argc, char *argv[])
{
  DWORD idDde = 0;
  HCONV HConversation;
  HSZ   Item;
  HSZ   Server;
  HSZ   Topic;
  const char* browser;
  HDDEDATA rc;
  int   verbose = 0;

  if (argc > 1 && strcmp(argv[1], "-V") == 0) {
    printf("$Id: activate.c,v 3.1 2000/10/25 16:17:01 lefevre Exp $\n");
    exit (1);
  }
  else if (argc < 2) {
    fprintf (stderr, "Usage : activate [-V] browser\n");
    exit (1);
  }
  browser = argv[1];

  DdeInitialize (&idDde, (PFNCALLBACK)DdeCallback, APPCMD_CLIENTONLY, 0);

  Server = DdeCreateStringHandle (idDde, browser, CP_WINANSI);
  Topic  = DdeCreateStringHandle (idDde, "WWW_Activate", CP_WINANSI);
  Item   = DdeCreateStringHandle (idDde, "0xFFFFFFFF,0x0", CP_WINANSI);

  HConversation = DdeConnect (idDde, Server, Topic, NULL);
  rc            = DdeClientTransaction (NULL, 0ul, HConversation, Item,
			CF_TEXT, XTYP_REQUEST, 30000, NULL);

  DdeDisconnect (HConversation);
  if(verbose) printf("Returned : %d for %s\n", rc, browser);

  DdeFreeStringHandle (idDde, Server);
  DdeFreeStringHandle (idDde, Topic);
  DdeFreeStringHandle (idDde, Item);
  DdeUninitialize (idDde);

  return rc == NULL ? 1 : 0;
}
/*____________________________________________________________________________*/

