/*____________________________________________________________________________*/
/**
 * XjShowURL is a program used to test communication between an X11
 * program and a java client. It can listen to what SocketDisplayer has to say.
 *
 * It is NOT built automatically by the Makefile.
 * To make it use something like:
 * cc -o XjShowURL -I/usr/X11/include XjShowURL.c -L/usr/X11/lib -lXm -lXt -lX11
 * Change the compiler, the include and library path if necessary.

 * Usage : XjShowURL [-d] [-p port]
 * Flag -d : debug mode, default port if not specified 8333.
 *
 * Jean-Paul Le Fvre - November 2000
 * $Id: XjShowURL.c,v 1.2 2000/12/01 09:17:28 lefevre Exp $
/*____________________________________________________________________________*/

#include <stdio.h>
#include <Xm/BulletinB.h>
#include <Xm/Label.h>
#include <Xm/TextF.h>
#include <netinet/in.h> 
#include <netdb.h>

static XtInputId addListener(XtAppContext, int, XtInputCallbackProc, XtPointer);
static void      updateURL(XtPointer, int*, XtInputId*);

static int 	 debug = 0;

int main(int argc, char **argv)
{
  Widget        toplevel;
  Widget        board;
  Widget        url_field;
  Widget        label;
  Arg           args[10];
  int           n;
  int		c;
  int		port = 8333;
  XFontStruct*  font;
  XmFontList    fontlist;
  XmString      string;
  Display*      display;
  XtAppContext  app_context;
  extern char*  optarg;


  while((c = getopt(argc, argv, "dp:")) != -1) {
    switch(c) {
    case 'd' :
      debug = 1;
      break;

    case 'p' :
      port = atoi(optarg);
      break;
    }
  }

  if(port < 1024 || port > 65534) {
    fprintf(stderr, "Invalid port number : %d\n", port);
    exit(1);
  }

  argc     = 1;
  toplevel = XtAppInitialize(&app_context, "XgPrintURL",
			     NULL, 0, &argc, argv, NULL, args, 0);

  /**
   * The GUI consists of a BulletinBoard, a Label and a TextField.
   */
  n = 0;
  XtSetArg (args[n], XmNallowShellResize, True); n++;
  XtSetArg (args[n], XmNheight, 100); n++;
  XtSetArg (args[n], XmNwidth,  700); n++;
  board = XmCreateBulletinBoard(toplevel, "board", args, n);
  XtManageChild(board);

  font     = XLoadQueryFont(XtDisplay(toplevel),"8x13");
  fontlist = XmFontListCreate(font, XmSTRING_DEFAULT_CHARSET);
  string   = XmStringCreate("URL : ", XmSTRING_DEFAULT_CHARSET); 

  n = 0;
  XtSetArg(args[n], XmNlabelString, string); n++;
  label = XmCreateLabel(board, "label", args, n);
  XtManageChild(label);
  XmStringFree(string);

  n = 0;
  XtSetArg(args[n], XmNy, 40); n++;
  XtSetArg(args[n], XmNcolumns, 80); n++;
  XtSetArg(args[n], XmNfontList, fontlist); n++;
  url_field = (Widget) XmCreateTextField(board, "text", args, n);
  XtManageChild(url_field);

  XtRealizeWidget(toplevel);

  /**
   * The new input source is added to the X11 machinery.
   * This source is what is coming from the port.
   */
  addListener(app_context, port, updateURL, url_field);

  XtAppMainLoop(app_context);

  return 0;
}
/*____________________________________________________________________________*/
/**
 * Adds an input source to the main event loop.
 *
 * @param context the application context.
 * @param port the port the application is listening.
 * @param proc the callback which is called when something arrives.
 * @param data an argument passed to the callback.
 * @return the id of the new input or -1 in case of error.
 * @see XtAppAddInput
 */
static XtInputId addListener(XtAppContext context, int port,
			     XtInputCallbackProc proc, XtPointer data)
{
  XtInputId id;
  int s;
  int l;
  struct sockaddr_in saddr;
  struct hostent*    host;

  s = socket(AF_INET, SOCK_STREAM, 0);
  if(s < 0) {
    perror("Can't create socket");
    return -1;
  }
  if(debug) printf("Socket created !\n");

  host = gethostbyname("localhost");

  saddr.sin_family = AF_INET;
  saddr.sin_port   = htons(port);
  memcpy(&saddr.sin_addr, host->h_addr, host->h_length);

  if(bind(s, &saddr, sizeof(saddr)) < 0) {
    perror("Can't bind socket");
    return -1;
  }

  if(debug) printf("Socket bound !\n");

  l = sizeof(saddr) ;
  if (getsockname(s, &saddr, &l) != 0) {
    perror("Can't get socket name");
    return -1;
  }
  if(debug) printf("Socket name got !\n");

  if(listen(s, 1) < 0) {
    perror("Can't listen to socket");
    return -1;
  }

  if(debug) printf("Socket ready !\n");

  id = XtAppAddInput(context, s, (XtPointer)XtInputReadMask, proc, data);

  if(debug) printf("Input added !\n");

  return id;
}
/*____________________________________________________________________________*/
/**
 * Updates the URL field when a new string is found from the connection.
 * @param field the TextField widget to update.
 * @param s the socket providing the data.
 * @param id the input id.
 */
static void updateURL(XtPointer field, int* s, XtInputId* id)
{
  int sfd;
  int n;
  char buffer[1024];
  Arg  args[1];

  if(debug) printf("Procedure called back\n");

  if((sfd = accept(*s, NULL, NULL)) < 0) {
     perror("Can't accept connection");
     return;
  }

  if(debug) printf("Connection accepted !\n");

  n = read(sfd, buffer, sizeof(buffer));
  if(n < 1) {
    perror("Can't read data");
    return;
  }

  buffer[n] = '\0'; 
  if(debug) printf("Got : %s (%d)\n", buffer, n);

  XtSetArg(args[0], XmNvalue, buffer);
  XtSetValues(field, args, 1);

  close(sfd);
}
/*____________________________________________________________________________*/
