//______________________________________________________________________________

//	Java Virtual Shelf
//______________________________________________________________________________

package org.demo.webwader;

/**
 * WebRoot : a convenient object used to simulate the root of a site.
 * <P>
 * The user object of this node is a WebPage.
 *
 * @see WebSite
 * @see org.demo.webwader.gui.TreePane
 * @version $Id: WebRoot.java,v 3.1 2000/10/25 16:15:02 lefevre Exp $
 * @author Jean-Paul Le Fvre
 */

public class WebRoot extends WebNode {
    /**
     * @serial the url associated with this root.
     */
private String url = "";

//______________________________________________________________________________
/**
 * Creates the node with a WebPage.
 */
public	WebRoot() throws InvalidLocatorException
  {
      super("/");
  }
//______________________________________________________________________________
/**
 * Gets the url.
 *
 * @return the path to the page or null in case of error.
 * @see WebPage#getPath()
 */
final public String getPagePath()
  {
      return url;
  }
//______________________________________________________________________________
/**
 * Gets the title to the web page.
 *
 * @return the title of the page.
 * @see WebPage#getTitle()
 */
final public String getTitle()
  {
      return toString();
  }
//______________________________________________________________________________
/**
 * Change the name of this node.
 * @param name the name of this root.
 */
public  void setName(String name)
  {
      setUserObject(name);
  }
//______________________________________________________________________________
/**
 * Converts this node to String.
 * @return the string.
 */
public String toString()
  {
      return getUserObject().toString();
  }
//______________________________________________________________________________
}





