//______________________________________________________________________________

//	The Java Virtual Shelf
//______________________________________________________________________________

package org.demo.webwader;
import org.ariane.tools.ToolBox;

/**
 * Provides information about the current release.
 * <br>
 * It is a singleton.
 * @version $Id: VersionInfo.java,v 3.31 2001/06/19 19:20:57 lefevre Exp $
 * @author Jean-Paul Le Fvre
 */
//______________________________________________________________________________

public class VersionInfo {
  /**
   * The version ID.
   */
public  final static String VERSION = "2.4.0";
  /**
   * The Release date.
   */
public  final static String DATE = "25 June 2001";
  /**
   * @serial The author.
   */
public  final static String AUTHOR = "JP.LeFevre@free.fr";
  /**
   * @serial The unique instance.
   */
private  static VersionInfo info = null;

//______________________________________________________________________________
/**
 * Gets an unique instance of the info.
 * <Br>
 * It is a singleton.
 * @return the unique instance.
 */
public static VersionInfo instance()
  {
    if(info == null) info = new VersionInfo();

    return info;
  }
//______________________________________________________________________________
/**
 * Creates the VersionInfo.
 */
private VersionInfo()
  {
  }
//______________________________________________________________________________
    /**
     * Prints info on standard output.
     */
static public void print()
    {
	System.out.println(instance().toString());
    }
//______________________________________________________________________________
    /**
     * Returns info in a string.
     * @return the string.
     */
public String toString()
    {
	StringBuffer buf = new StringBuffer("WebWader package : version ");
	buf.append(VERSION).append(" since ").append(DATE);
	buf.append("\nClasses taken in : ").append(ToolBox.getJVSOrigin());
	return buf.toString();
    }
//______________________________________________________________________________
    /**
     * Prints version number on standard output.
     * <br>
     * Used by make distrib.
     */
static public void main(String args[])
    {
	if(args.length < 1) {
	    System.out.print(VERSION);
	}
	else if(args[0].equals("-d")) {
	   System.out.println(VersionInfo.instance().toString()); 
	}
    }
//______________________________________________________________________________
}


