//______________________________________________________________________________

//	Java Virtual Shelf
//______________________________________________________________________________

package org.demo.webwader;

import org.ariane.tools.*;
import java.io.*;
import java.net.*;
import java.util.*;

/**
 * SendURL : a test program of the webwader package.
 * <p>
 * An URL, actually a string, is sent to a socket. It can be read
 * by a server listening the connection. (see <code>XjShowURL</code>)
 *
 * @see org.demo.webwader.rbi.ShowURL
 * @version $Id: SendURL.java,v 1.3 2001/01/15 16:36:59 lefevre Exp $
 * @author  Jean-Paul Le Fvre
 */

class SendURL extends TryProg {
  /**
   * @serial The port identifying the connection.
   */
    private int port = 8333;

//______________________________________________________________________________
  /**
   * Starts the program
   */
public static void main (String args[])
  {
      SendURL prog = new SendURL("SendURL");

      if (! prog.parseArg(args)) {
	  ToolBox.warn("Can't parse command line");
	  return;
      }
      else if (! prog.run()) {
	  ToolBox.warn("Can't run " + prog.getName());
	  System.exit(ToolBox.OK);
      }
  }
//______________________________________________________________________________
/**
 * Creates the object.
 * @param name the name of the program.
 */
public SendURL(String name)
  {
    super(name);
  }
//______________________________________________________________________________
/**
 * Actually starts the program.
 * <br>
 * It loops while new strings are entered. It stops when 'quit' is
 * given as input.
 */
public	boolean run()
  {
      if(ToolBox.verbose) ToolBox.warn("Connecting to port " + port);
      ToolBox.warn("Enter 'quit' to stop");
      BufferedReader d = new BufferedReader(new InputStreamReader(System.in));

      try {

	  while(true) {

	      System.out.print("URL : ");
	      String url= d.readLine();

	      if(url == null || url.equalsIgnoreCase("quit")) {
		  return true;
	      }
	      sendURL(url);
	  }
      }
      catch(Exception ex) { 
	  ToolBox.warn("Can't communicate with the server", ex);
	  if(ToolBox.debug) ex.printStackTrace();
	  return false;
      }
  }
//______________________________________________________________________________
    /**
     * Sends the string to the connection.
     * @param url the string to send.
     * @throw UnknownHostException if the socket cannot be created.
     * @throw IOException if the string cannot be written.
     */
final private void sendURL(String url) throws UnknownHostException, IOException
  {
      if(ToolBox.debug) System.out.println(url);

      Socket socket = new Socket("localhost", port);

      BufferedOutputStream out = new BufferedOutputStream(
				     socket.getOutputStream());
      out.write(url.getBytes() , 0, url.length());
      out.flush();
      out.close();
  }
//______________________________________________________________________________
    /**
     * Prints how to use the program.
     */
final private void printUsage()
  {
      System.out.println(
      "Usage   : java org.demo.webwader.SendURL [options]");
      System.out.println(
      "Options : [-v|-d|-q][-V][-h][-p port]");
  }
//______________________________________________________________________________
/**
 * Parses the command line
 * Usage   : [-q|v|d][-V][-h][-p port]
 * @param args the command line.
 */
public	boolean parseArg(String args[])
  {
    int i     = 0;
    int error = 0;

    while(i < args.length && args[i].startsWith("-")) {

      String arg = args[i++];
      int j;

      for (j = 1; j < arg.length(); j++) {

	char flag = arg.charAt(j);

	switch (flag) {
	case 'V':
	  VersionInfo.print();
	  break;

	case 'q':
	  ToolBox.verbose = false;
	  ToolBox.debug   = false;
	  break;

	case 'v':
	  ToolBox.verbose = true;
	  ToolBox.debug   = false;
	  break;

	case 'd':
	  ToolBox.verbose = true;
	  ToolBox.debug   = true;
	  break;

	case 'p':
	  port = Integer.parseInt(args[i++]);
	  break;

	default	:
	  printUsage();
	  error++;
	  break;
	}
      }
    }

    return (error == 0);
  }
//______________________________________________________________________________
}
